/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Optional;

public class OptionalDeserializer
extends ContainerDeserializerBase<Optional> {
    private JsonDeserializer<Object> elementDeserializer;

    public OptionalDeserializer(JsonDeserializer elementDeserializer, JavaType contentType) {
        super(contentType);
        this.elementDeserializer = elementDeserializer;
    }

    public Optional deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return Optional.of(typeDeserializer.deserializeTypedFromAny(jp, ctxt));
    }

    public Optional deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (this.elementDeserializer == null) {
            this.elementDeserializer = ctxt.findNonContextualValueDeserializer(this._containerType);
        }
        Object containedObject = this.elementDeserializer.deserialize(jp, ctxt);
        return Optional.of(containedObject);
    }

    public Optional getNullValue() {
        return Optional.empty();
    }

    public JsonDeserializer<Object> getContentDeserializer() {
        return this.elementDeserializer;
    }
}

