/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.rest.serialization.jackson2.MapAndKeyValuePairDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichedMapDeserializer
extends MapAndKeyValuePairDeserializer {
    private static final Logger log = LoggerFactory.getLogger(EnrichedMapDeserializer.class);
    private static final String JSON_EXCEPTION_STACK_TRACE_MSG = "JsonMappingException stacktrace:";
    private BeanDescription beanDescription;
    private JavaType mapType;
    private ValueInstantiator valueInstantiator;

    public EnrichedMapDeserializer(JavaType mapType, BeanDescription beanDescription, MapDeserializer src) {
        super(src);
        this.beanDescription = beanDescription;
        this.mapType = mapType;
    }

    public void resolve(final DeserializationContext ctxt) throws JsonMappingException {
        StdValueInstantiator delegateInstantiator = (StdValueInstantiator)BeanDeserializerFactory.instance.findValueInstantiator(ctxt, this.beanDescription);
        this.valueInstantiator = new StdValueInstantiator(delegateInstantiator){

            public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
                Map newMap = (Map)super.createUsingDefault(ctxt);
                return new NullIgnoringMap(newMap);
            }
        };
    }

    public EnrichedMapDeserializer(JavaType mapType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(mapType, valueInstantiator, keyDeser, valueDeser, valueTypeDeser);
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return BuilderUtils.modelMap((Map)super.deserialize(jp, ctxt));
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException {
        return BuilderUtils.modelMap(super.deserialize(jp, ctxt, result));
    }

    private static KeyDeserializer robustKeyDeserializer(final KeyDeserializer keyDeser) {
        return new KeyDeserializer(){

            public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
                if (key != null && key.startsWith("_")) {
                    return null;
                }
                if (keyDeser == null) {
                    return key;
                }
                try {
                    return keyDeser.deserializeKey(key, ctxt);
                }
                catch (JsonMappingException e) {
                    log.warn("Unable to deserialize map key from: {}, turn on debug-level logging for more detail.", (Object)key);
                    log.debug(EnrichedMapDeserializer.JSON_EXCEPTION_STACK_TRACE_MSG, (Throwable)e);
                    return null;
                }
            }
        };
    }

    private static JsonDeserializer<Object> robustValueSerializer(final JsonDeserializer<?> elementDeserializer) {
        return new JsonDeserializer(){

            public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                try {
                    return elementDeserializer.deserialize(jp, ctxt);
                }
                catch (JsonMappingException e) {
                    log.warn("Unable to deserialize map value, turn on debug-level logging for more detail.");
                    log.debug(EnrichedMapDeserializer.JSON_EXCEPTION_STACK_TRACE_MSG, (Throwable)e);
                    return null;
                }
            }

            public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
                try {
                    return super.deserializeWithType(jp, ctxt, typeDeserializer);
                }
                catch (JsonMappingException e) {
                    log.warn("Unable to deserializeWithType map value, turn on debug-level logging for more detail.");
                    log.debug(EnrichedMapDeserializer.JSON_EXCEPTION_STACK_TRACE_MSG, (Throwable)e);
                    return null;
                }
            }
        };
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeser, TypeDeserializer valueTypeDeser, JsonDeserializer<?> valueDeser, NullValueProvider nuller, Set<String> ignorable) {
        return this.withResolved(keyDeser, valueTypeDeser, valueDeser, nuller, ignorable, this._includableProperties);
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeser, TypeDeserializer valueTypeDeser, JsonDeserializer<?> valueDeser, NullValueProvider nuller, Set<String> ignorable, Set<String> includable) {
        EnrichedMapDeserializer inst = new EnrichedMapDeserializer(this.mapType, this.valueInstantiator, EnrichedMapDeserializer.robustKeyDeserializer(keyDeser), EnrichedMapDeserializer.robustValueSerializer(valueDeser), valueTypeDeser);
        inst.setIgnorableProperties(new UnderscorePrefixedStringContainingHashSet((Set<String>)new HashSet<String>()));
        inst.setIncludableProperties(includable);
        return inst;
    }

    private static class UnderscorePrefixedStringContainingHashSet
    extends HashSet<String> {
        public UnderscorePrefixedStringContainingHashSet(Set<String> ignorableProperties) {
            if (ignorableProperties != null) {
                this.addAll(ignorableProperties);
            }
        }

        @Override
        public boolean contains(Object o) {
            String s;
            if (o instanceof String && (s = (String)o).startsWith("_")) {
                return true;
            }
            return super.contains(o);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class NullIgnoringMap<K, V>
    extends LinkedHashMap<K, V> {
        private NullIgnoringMap(Map m) {
            super(m);
        }

        @Override
        public V put(K key, V value) {
            if (key == null || value == null) {
                return null;
            }
            return super.put(key, value);
        }
    }
}

