/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.graphql;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.rest.client.AbstractRemoteContentLabelService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.graphql.GraphQLQueryResponse;
import com.atlassian.confluence.rest.client.graphql.GraphQLUtils;
import com.atlassian.confluence.rest.serialization.graphql.GraphQLPageResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

@Internal
public class GraphQLRemoteContentLabelServiceImpl
extends AbstractRemoteContentLabelService {
    public GraphQLRemoteContentLabelServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public CompletionStage<PageResponse<Label>> getLabelsCompletionStage(ContentId contentId, Collection<Label.Prefix> prefixes, PageRequest request) {
        String requestString = this.buildGetLabelsRequestString(contentId, prefixes, request);
        CompletionStage<GraphQLQueryLabelsResponse> responsePromise = this.postCompletionStage(this.newGraphWebResource(), GraphQLQueryLabelsResponse.class, requestString);
        return responsePromise.thenApplyAsync(this::getLabelsFromResponse, this.getExecutor());
    }

    @VisibleForTesting
    GraphQLPageResponse<Label> getLabelsFromResponse(GraphQLQueryLabelsResponse response) {
        response.throwFirstErrorIfExists();
        List contents = (List)((Map)((Map)response.getData()).get("content")).get("nodes");
        if (contents.isEmpty()) {
            throw new NotFoundException();
        }
        return (GraphQLPageResponse)((Map)contents.get(0)).get("labels");
    }

    private String buildGetLabelsRequestString(ContentId contentId, Collection<Label.Prefix> prefixes, PageRequest request) {
        List prefixStrings;
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        if (request != null) {
            arguments.put("offset", request.getStart());
            arguments.put("first", request.getLimit());
        }
        if ((prefixStrings = prefixes.stream().map(Object::toString).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList))) != null) {
            arguments.put("prefix", prefixStrings);
        }
        String query = "{\n  content(id: \"" + contentId.asLong() + "\") {\n    nodes {\n      labels" + GraphQLUtils.buildGraphQLFieldArgumentsString(arguments) + " {\n        count\n        nodes {\n          id\n          name\n          prefix\n        }\n        pageInfo {\n          hasNextPage\n        }\n      }\n    }\n  }\n}";
        return GraphQLUtils.buildRequestString(query);
    }

    private WebResource newGraphWebResource() {
        return this.provider.newRestWebResource().path("rest").path("graph/");
    }

    public static class GraphQLQueryLabelsResponse
    extends GraphQLQueryResponse<Map<String, Map<String, List<Map<String, GraphQLPageResponse<Label>>>>>> {
    }
}

