/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Credentials;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.PasswordChangeDetails;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.UserDetailsForCreation;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemotePersonService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.sal.api.user.UserKey;
import com.sun.jersey.api.client.WebResource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RemotePersonServiceImpl
extends AbstractRemoteService<PersonService>
implements RemotePersonService {
    public RemotePersonServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public CompletionStage<com.atlassian.confluence.api.model.people.UserKey> create(UserDetailsForCreation userDetailsForCreation) {
        String path = "/admin/user";
        WebResource resource = this.newRestWebResource().path("/admin/user");
        return this.postCompletionStage(resource, com.atlassian.confluence.api.model.people.UserKey.class, userDetailsForCreation);
    }

    @Override
    public CompletionStage<Person> getCurrentUserCompletionStage(Expansion ... expansions) {
        return this.getCompletionStage(this.newUserResource().path("/current"), Person.class);
    }

    @Override
    public PersonService.Validator validator() {
        throw new NotImplementedServiceException("Remote validation is not supported");
    }

    @Override
    public RemotePersonService.RemotePersonFinder find(Expansion ... expansions) {
        return new RemotePersonFinderImpl(this, expansions);
    }

    @Override
    public CompletionStage<Void> disable(String username) {
        String path = "/admin/user/" + username + "/disable";
        WebResource resource = this.newRestWebResource().path(path);
        return this.putCompletionStage(resource, Void.class, null);
    }

    @Override
    public CompletionStage<Void> enable(String username) {
        String path = "/admin/user/" + username + "/enable";
        WebResource resource = this.newRestWebResource().path(path);
        return this.putCompletionStage(resource, Void.class, null);
    }

    @Override
    public LongTaskSubmission delete(Person personToDelete) {
        throw new NotImplementedServiceException("Remote user deletion is not supported");
    }

    @Override
    public RemotePersonService.RemotePersonSearcher search() {
        throw new NotImplementedServiceException("Remote search is not supported");
    }

    @Override
    public CompletionStage<Void> addMembership(String username, String groupName) {
        String path = "/user/" + username + "/group/" + groupName;
        WebResource resource = this.newRestWebResource().path(path);
        return this.putCompletionStage(resource, Void.class, null);
    }

    @Override
    public CompletionStage<Void> removeMembership(String username, String groupName) {
        String path = "/user/" + username + "/group/" + groupName;
        WebResource resource = this.newRestWebResource().path(path);
        return this.deleteCompletionStage(resource, Void.class);
    }

    @Override
    public CompletionStage<Void> changeUserPassword(String username, String newPass) {
        String path = "/admin/user/" + username + "/password";
        WebResource resource = this.newRestWebResource().path(path);
        Credentials newCredentials = new Credentials();
        newCredentials.setPassword(newPass);
        return this.postVoidCompletionStage(resource, newCredentials);
    }

    @Override
    public CompletionStage<Void> changeMyPassword(PasswordChangeDetails passwordChangeDetails) {
        String path = "/user/current/password";
        WebResource resource = this.newRestWebResource().path("/user/current/password");
        return this.postVoidCompletionStage(resource, passwordChangeDetails);
    }

    private WebResource newUserResource() {
        return this.newRestWebResource().path("/user");
    }

    private WebResource newGroupResource() {
        return this.newRestWebResource().path("/group");
    }

    private WebResource newUserResource(@Nullable UserKey key, @Nullable String username) {
        return this.addUserIdentifierQueryParam(this.newUserResource(), key, username);
    }

    private WebResource addUserIdentifierQueryParam(WebResource resource, @Nullable UserKey key, @Nullable String username) {
        if (key == null && username == null) {
            throw new UnsupportedOperationException("User key or username is required but both were null");
        }
        if (key != null && username != null) {
            throw new UnsupportedOperationException("Only one of key or username is required, but both were provided");
        }
        resource = key != null ? resource.queryParam("key", key.getStringValue()) : resource.queryParam("username", username);
        return resource;
    }

    public class RemotePersonFinderImpl
    extends AbstractRemoteService<PersonService.PersonFinder>
    implements RemotePersonService.RemotePersonFinder {
        private UserKey key;
        private String username;
        private Group group;
        private final Expansion[] expansions;

        protected RemotePersonFinderImpl(AbstractRemoteService other, Expansion ... expansions) {
            super(other);
            this.expansions = expansions;
        }

        @Override
        public RemotePersonService.RemotePersonFinder withUserKey(UserKey key) {
            this.key = key;
            return this;
        }

        @Override
        public RemotePersonService.RemotePersonFinder withUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        public RemotePersonService.RemotePersonFinder withMembershipOf(Group group) {
            this.group = group;
            return this;
        }

        @Override
        public CompletionStage<Optional<Person>> fetchCompletionStage() {
            WebResource resource = this.addExpansions(RemotePersonServiceImpl.this.newUserResource(this.key, this.username), this.expansions);
            return this.getCompletionStageOptional(resource, Person.class);
        }

        @Override
        public CompletionStage<PageResponse<Person>> fetchManyCompletionStage(PageRequest pageRequest) {
            if (this.group == null) {
                throw new NotImplementedServiceException("Cannot bulk fetch groups without a membership query");
            }
            WebResource resource = RemotePersonServiceImpl.this.newGroupResource().path(this.group.getName()).path("member");
            resource = this.addPageRequest(resource, pageRequest);
            return this.getCompletionStagePageResponseList(resource, Person.class);
        }
    }
}

