/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.locator.ContentLocator;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.client.RemoteSingleFetcher;
import com.atlassian.confluence.rest.client.util.PromiseUtils;
import com.atlassian.util.concurrent.Promise;
import java.time.LocalDate;
import java.util.Map;
import java.util.concurrent.CompletionStage;

@ExperimentalApi
public interface RemoteContentService {
    public RemoteContentFinder find(Expansion ... var1);

    @Deprecated
    default public Promise<Content> create(Content newContent) {
        return PromiseUtils.toPromise(this.createCompletionStage(newContent));
    }

    public CompletionStage<Content> createCompletionStage(Content var1);

    @Deprecated
    default public Promise<Content> create(Content newContent, Expansion ... expansions) throws ServiceException {
        return PromiseUtils.toPromise(this.createCompletionStage(newContent, expansions));
    }

    public CompletionStage<Content> createCompletionStage(Content var1, Expansion ... var2) throws ServiceException;

    @Deprecated
    default public Promise<Content> update(Content content) {
        return PromiseUtils.toPromise(this.updateCompletionStage(content));
    }

    @Deprecated
    default public Promise<Content> trash(Content content) {
        return PromiseUtils.toPromise(this.trashCompletionStage(content));
    }

    @Deprecated
    default public Promise<Content> restore(Content content) {
        return PromiseUtils.toPromise(this.restoreCompletionStage(content));
    }

    @Deprecated
    default public Promise<Void> purge(Content content) {
        return PromiseUtils.toPromise(this.purgeCompletionStage(content));
    }

    @Deprecated
    default public Promise<Void> delete(Content content) {
        return PromiseUtils.toPromise(this.deleteCompletionStage(content));
    }

    public CompletionStage<Content> updateCompletionStage(Content var1);

    public CompletionStage<Content> trashCompletionStage(Content var1);

    public CompletionStage<Content> restoreCompletionStage(Content var1);

    public CompletionStage<Void> purgeCompletionStage(Content var1);

    public CompletionStage<Void> deleteCompletionStage(Content var1);

    @Deprecated
    default public Promise<PageResponse<Content>> getChildren(Content parent, PageRequest pageRequest, Expansion ... expansion) {
        return PromiseUtils.toPromise(this.getChildrenCompletionStage(parent, pageRequest, expansion));
    }

    public CompletionStage<PageResponse<Content>> getChildrenCompletionStage(Content var1, PageRequest var2, Expansion ... var3);

    public static interface RemoteContentFetcher
    extends RemoteSingleContentFetcher {
        @Deprecated
        default public Promise<PageResponse<Content>> fetchMany(ContentType type, PageRequest request) {
            return PromiseUtils.toPromise(this.fetchManyCompletionStage(type, request));
        }

        public CompletionStage<PageResponse<Content>> fetchManyCompletionStage(ContentType var1, PageRequest var2);

        @Deprecated
        default public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByContentType(PageRequest request) {
            return PromiseUtils.toPromise(this.fetchMappedByContentTypeCompletionStage(request));
        }

        public CompletionStage<Map<ContentType, PageResponse<Content>>> fetchMappedByContentTypeCompletionStage(PageRequest var1);
    }

    public static interface RemoteSingleContentFetcher
    extends RemoteSingleFetcher<Content> {
    }

    public static interface RemoteParameterContentFinder
    extends RemoteContentFetcher {
        public RemoteParameterContentFinder withSpace(Space ... var1);

        public RemoteParameterContentFinder withType(ContentType ... var1);

        @Deprecated
        public RemoteParameterContentFinder withCreatedDate(org.joda.time.LocalDate var1);

        public RemoteParameterContentFinder withCreatedDate(LocalDate var1);

        public RemoteParameterContentFinder withTitle(String var1);
    }

    public static interface RemoteContentFinder
    extends RemoteParameterContentFinder {
        public RemoteSingleContentFetcher withId(ContentId var1);

        public RemoteSingleContentFetcher withIdAndVersion(ContentId var1, int var2);

        public RemoteSingleContentFetcher withId(ContentId var1, ContentId ... var2);

        public RemoteSingleContentFetcher withId(Iterable<ContentId> var1);

        public RemoteSingleContentFetcher withLocator(ContentLocator var1);

        public RemoteContentFinder withStatus(ContentStatus ... var1);

        public RemoteContentFinder withAnyStatus();
    }
}

