/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.client.PromisingExecutorService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.model.ExceptionConverter;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteService<P> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteService.class);
    protected final AuthenticatedWebResourceProvider provider;
    private final PromisingExecutorService executor;

    protected AbstractRemoteService(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        this(provider, new PromisingExecutorService(executor));
    }

    protected AbstractRemoteService(AbstractRemoteService other) {
        this(other.provider, other.executor);
    }

    protected AbstractRemoteService(AuthenticatedWebResourceProvider provider, PromisingExecutorService executor) {
        this.provider = provider;
        this.executor = executor;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    protected WebResource newRestWebResource() {
        return this.provider.newRestWebResource().path("rest").path("api");
    }

    protected WebResource newExperimentalRestWebResource() {
        return this.provider.newRestWebResource().path("rest").path("experimental");
    }

    @Deprecated
    protected <T> Promise<T> getFuture(WebResource resource, Class<? extends T> entityClass) {
        return this.executor.submit(() -> this.getOption(resource, entityClass).getOrThrow(NotFoundException::new));
    }

    protected <T> CompletionStage<T> getCompletionStage(WebResource resource, Class<? extends T> entityClass) {
        return CompletableFuture.supplyAsync(() -> this.getOptional(resource, entityClass).orElseThrow(NotFoundException::new), this.executor);
    }

    @Deprecated
    protected <T> Promise<Option<T>> getFutureOption(WebResource resource, Class<? extends T> entityClass) {
        return this.executor.submit(() -> this.getOption(resource, entityClass));
    }

    protected <T> CompletionStage<Optional<T>> getCompletionStageOptional(WebResource resource, Class<? extends T> entityClass) {
        return CompletableFuture.supplyAsync(() -> this.getOptional(resource, entityClass), this.executor);
    }

    @Deprecated
    protected <E> Promise<PageResponse<E>> getFuturePageResponseList(WebResource resource, Class<E> contentClass) {
        return this.executor.submit(() -> this.getPartialList(resource, contentClass));
    }

    protected <E> CompletionStage<PageResponse<E>> getCompletionStagePageResponseList(WebResource resource, Class<E> contentClass) {
        return CompletableFuture.supplyAsync(() -> this.getPartialList(resource, contentClass), this.executor);
    }

    protected <E> CompletionStage<SearchPageResponse<E>> getCompletionStageSearchPageResponseList(WebResource resource, Class<E> contentClass) {
        return CompletableFuture.supplyAsync(() -> this.getSearchPartialList(resource, contentClass), this.executor);
    }

    @Deprecated
    protected <K, V> Promise<Map<K, PageResponse<V>>> getFutureMapOfPageResponses(WebResource resource, Class<K> keyClass, Class<V> listContentClass) {
        GenericType<Map> mapType = this.getGenericType(Map.class, keyClass, AbstractRemoteService.getParameterizedType(RestList.class, listContentClass));
        Promise<Map> promise = this.getFutureGenericMap(resource, mapType);
        return promise;
    }

    protected <K, V> CompletionStage<Map<K, PageResponse<V>>> getCompletionStageMapOfPageResponses(WebResource resource, Class<K> keyClass, Class<V> listContentClass) {
        GenericType<Map> mapType = this.getGenericType(Map.class, keyClass, AbstractRemoteService.getParameterizedType(RestList.class, listContentClass));
        return this.getCompletionStageGenericMap(resource, mapType);
    }

    @Deprecated
    protected <K, V> Promise<Map<K, V>> getFutureMap(WebResource resource, Class<K> keyClass, Class<V> valueClass) {
        GenericType<Map> mapType = this.getGenericType(Map.class, keyClass, valueClass);
        Promise<Map> promise = this.getFutureGenericMap(resource, mapType);
        return promise;
    }

    protected <K, V> CompletionStage<Map<K, V>> getCompletionStageMap(WebResource resource, Class<K> keyClass, Class<V> valueClass) {
        GenericType<Map> mapType = this.getGenericType(Map.class, keyClass, valueClass);
        return this.getCompletionStageGenericMap(resource, mapType);
    }

    @Deprecated
    protected <E> Promise<Iterable<E>> getFutureGenericCollection(WebResource resource, Class<? extends Iterable> collectionType, Class<E> contentType) {
        return this.executor.submit(() -> this.getGenericIterable(resource, collectionType, contentType));
    }

    protected <E> CompletionStage<Iterable<E>> getCompletionStageGenericCollection(WebResource resource, Class<? extends Iterable> collectionType, Class<E> contentType) {
        return CompletableFuture.supplyAsync(() -> this.getGenericIterable(resource, collectionType, contentType), this.executor);
    }

    @Deprecated
    protected <E> Promise<E> postFuture(WebResource resource, Class<? extends E> entityClass, @Nullable Object postEntity) {
        return this.postFuture(resource, entityClass, postEntity, MediaType.APPLICATION_JSON_TYPE);
    }

    protected <E> CompletionStage<E> postCompletionStage(WebResource resource, Class<? extends E> entityClass, @Nullable Object postEntity) {
        return this.postCompletionStage(resource, entityClass, postEntity, MediaType.APPLICATION_JSON_TYPE);
    }

    @Deprecated
    protected <E> Promise<E> postFuture(WebResource resource, Class<? extends E> entityClass, @Nullable Object postEntity, MediaType mediaType) {
        return this.executor.submit(() -> this.post(resource, entityClass, postEntity, mediaType));
    }

    protected <E> CompletionStage<E> postCompletionStage(WebResource resource, Class<? extends E> entityClass, @Nullable Object postEntity, MediaType mediaType) {
        return CompletableFuture.supplyAsync(() -> this.post(resource, entityClass, postEntity, mediaType), this.executor);
    }

    @Deprecated
    protected <E> Promise<E> postFuture(WebResource resource, Class<E> collectionClass, Class contentType, Object postEntity) {
        return this.executor.submit(() -> this.post(resource, collectionClass, contentType, postEntity));
    }

    protected <E> CompletionStage<E> postCompletionStage(WebResource resource, Class<E> collectionClass, Class contentType, Object postEntity) {
        return CompletableFuture.supplyAsync(() -> this.post(resource, collectionClass, contentType, postEntity), this.executor);
    }

    @Deprecated
    protected <T> Promise<PageResponse<T>> postFutureToPageResponse(WebResource resource, Class<T> entityClass, Object postEntity, MediaType mediaType) {
        return this.executor.submit(() -> this.postToPageResponse(resource, entityClass, postEntity, mediaType));
    }

    protected <T> CompletionStage<PageResponse<T>> postCompletionStageToPageResponse(WebResource resource, Class<T> entityClass, Object postEntity, MediaType mediaType) {
        return CompletableFuture.supplyAsync(() -> this.postToPageResponse(resource, entityClass, postEntity, mediaType), this.executor);
    }

    @Deprecated
    protected <T> Promise<T> putFuture(WebResource resource, Class<? extends T> entityClass, @Nullable Object putEntity) {
        return this.executor.submit(() -> this.put(resource, entityClass, putEntity));
    }

    protected <T> CompletionStage<T> putCompletionStage(WebResource resource, Class<? extends T> entityClass, @Nullable Object putEntity) {
        return CompletableFuture.supplyAsync(() -> this.put(resource, entityClass, putEntity), this.executor);
    }

    @Deprecated
    protected Promise<Void> deleteFuture(WebResource resource) {
        return this.deleteFuture(resource, Void.class);
    }

    protected CompletionStage<Void> deleteCompletionStage(WebResource resource) {
        return this.deleteCompletionStage(resource, Void.class);
    }

    @Deprecated
    protected <T> Promise<T> deleteFuture(WebResource resource, Class<? extends T> responseClass) {
        return this.executor.submit(() -> this.delete(resource, responseClass));
    }

    protected <T> CompletionStage<T> deleteCompletionStage(WebResource resource, Class<? extends T> responseClass) {
        return CompletableFuture.supplyAsync(() -> this.delete(resource, responseClass), this.executor);
    }

    protected WebResource addExpansions(WebResource resource, @Nullable Expansion[] expansions) {
        if (expansions == null || expansions.length == 0) {
            return resource;
        }
        return resource.queryParam("expand", ExpansionsParser.asString((Expansion[])expansions));
    }

    protected WebResource addPageRequestParams(WebResource resource, @Nullable PageRequest request) {
        if (request == null) {
            return resource;
        }
        return resource.queryParam("start", Integer.toString(request.getStart())).queryParam("limit", Integer.toString(request.getLimit()));
    }

    private <E> Option<E> getOption(WebResource resource, Class<? extends E> clazz) throws ServiceException {
        try {
            Object entity = resource.get(clazz);
            return Option.some((Object)entity);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatusInfo().getStatusCode() == ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                log.debug("404 being converted to Option.none : {}", (Object)e.getMessage());
                return Option.none();
            }
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <E> Optional<E> getOptional(WebResource resource, Class<? extends E> clazz) throws ServiceException {
        try {
            Object entity = resource.get(clazz);
            return Optional.of(entity);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatusInfo().getStatusCode() == ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                log.debug("404 being converted to Optional.empty : {}", (Object)e.getMessage());
                return Optional.empty();
            }
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <E> PageResponse<E> getPartialList(WebResource resource, Class<E> contentClass) throws ServiceException {
        return (PageResponse)this.getGenericIterable(resource, RestList.class, contentClass);
    }

    private <E> SearchPageResponse<E> getSearchPartialList(WebResource resource, Class<E> contentClass) throws ServiceException {
        RestList restList = (RestList)this.getGenericIterable(resource, RestList.class, contentClass);
        SearchPageResponse.Builder builder = SearchPageResponse.builder().result((Iterable)restList).pageRequest(restList.getPageRequest()).hasMore(restList.hasMore()).cqlQuery((String)restList.getProperty("cqlQuery")).totalSize(((Integer)restList.getProperty("totalSize")).intValue()).searchDuration(((Integer)restList.getProperty("searchDuration")).intValue());
        if (restList.hasProperty("archivedResultCount")) {
            builder.withArchivedResultCount(Optional.of((Integer)restList.getProperty("archivedResultCount")));
        }
        return builder.build();
    }

    private <G> GenericType<G> getGenericType(Class<G> collectionType, Type ... typeParameters) {
        return new GenericType((Type)AbstractRemoteService.getParameterizedType(collectionType, typeParameters));
    }

    private static ParameterizedType getParameterizedType(final Class type, final Type ... typeParameters) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeParameters;
            }

            @Override
            public Type getRawType() {
                return type;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    private <K, V> Promise<Map> getFutureGenericMap(WebResource resource, GenericType<Map> mapType) {
        return this.executor.submit(() -> {
            try {
                return Maps.filterEntries((Map)((Map)resource.get(mapType)), entry -> !entry.getKey().toString().startsWith("_"));
            }
            catch (UniformInterfaceException e) {
                throw ExceptionConverter.Client.convertToServiceException(e);
            }
        });
    }

    private <K, V> CompletionStage<Map<K, V>> getCompletionStageGenericMap(WebResource resource, GenericType<Map> mapType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Map map = (Map)resource.get(mapType);
                return map.entrySet().stream().filter(entry -> !entry.getKey().toString().startsWith("_")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            catch (UniformInterfaceException e) {
                throw ExceptionConverter.Client.convertToServiceException(e);
            }
        }, this.executor);
    }

    private <T> Iterable<T> getGenericIterable(WebResource resource, Class<? extends Iterable> collectionType, Class<T> contentClass) throws ServiceException {
        try {
            return (Iterable)resource.get(this.getGenericType(collectionType, contentClass));
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> PageResponse<T> postToPageResponse(WebResource resource, final Class<T> contentClass, Object postEntity, MediaType mediaType) throws ServiceException {
        try {
            ParameterizedType restListType = new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{contentClass};
                }

                @Override
                public Type getRawType() {
                    return RestList.class;
                }

                @Override
                public @Nullable Type getOwnerType() {
                    return null;
                }
            };
            WebResource.Builder builder = resource.type(mediaType);
            this.setAtlassianTokenIfNeeded(builder, mediaType);
            return (PageResponse)builder.post(new GenericType((Type)restListType), postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> T post(WebResource resource, Class<? extends T> clazz, @Nullable Object postEntity, MediaType mediaType) throws ServiceException {
        try {
            WebResource.Builder builder = resource.type(mediaType);
            this.setAtlassianTokenIfNeeded(builder, mediaType);
            return (T)builder.post(clazz, postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> T post(WebResource resource, Class<T> collectionType, Class contentClass, Object postEntity) throws ServiceException {
        try {
            GenericType<T> type = this.getGenericType(collectionType, contentClass);
            return (T)resource.type(MediaType.APPLICATION_JSON_TYPE).post(type, postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private void setAtlassianTokenIfNeeded(WebResource.Builder builder, MediaType mediaType) {
        if (mediaType != MediaType.APPLICATION_JSON_TYPE) {
            builder.header("X-Atlassian-Token", (Object)"no-check");
        }
    }

    private <T> @Nullable T put(WebResource resource, Class<? extends T> clazz, @Nullable Object putEntity) throws ServiceException {
        try {
            WebResource.Builder builder = resource.type(MediaType.APPLICATION_JSON_TYPE);
            if (clazz == Void.class) {
                builder.put();
                return null;
            }
            return (T)builder.put(clazz, putEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> @Nullable T delete(WebResource resource, Class<? extends T> clazz) throws ServiceException {
        try {
            WebResource.Builder builder = resource.type(MediaType.APPLICATION_JSON_TYPE);
            if (clazz == Void.class) {
                builder.delete();
                return null;
            }
            return (T)builder.delete(clazz);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    protected WebResource addPageRequest(WebResource resource, PageRequest pageRequest) {
        return this.addPageRequestParams(resource, pageRequest);
    }
}

