/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.atlassian.util.concurrent.RuntimeInterruptedException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public class PromisingExecutorService
implements ExecutorService {
    private final ListeningExecutorService delegate;

    public PromisingExecutorService(ListeningExecutorService service) {
        this.delegate = service;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> Promise<T> submit(Callable<T> task) {
        ListenableFuture listenableFuture = this.delegate.submit(task);
        return PromisingExecutorService.forListenableFuture(listenableFuture, this.delegate);
    }

    public <T> Promise<T> submit(Runnable task, @Nullable T result) {
        return PromisingExecutorService.forListenableFuture(this.delegate.submit(task, result), this.delegate);
    }

    public Promise<?> submit(Runnable task) {
        return PromisingExecutorService.forListenableFuture(this.delegate.submit(task), this.delegate);
    }

    <T> List<Future<T>> toListOfPromises(List<Future<T>> futures) {
        return Lists.transform(futures, input -> {
            if (input instanceof ListenableFuture) {
                return PromisingExecutorService.forListenableFuture((ListenableFuture)input, this.delegate);
            }
            return PromisingExecutorService.forFuture(input, this.delegate);
        });
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.toListOfPromises(this.delegate.invokeAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.toListOfPromises(this.delegate.invokeAll(tasks, timeout, unit));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    private static <T> Promise<T> forListenableFuture(ListenableFuture<T> listenableFuture, ListeningExecutorService delegate) {
        return new Of<T>(listenableFuture, delegate);
    }

    private static <T> Promise<T> forFuture(Future<T> input, ListeningExecutorService delegate) {
        return new Of(JdkFutureAdapters.listenInPoolThread(Objects.requireNonNull(input)), delegate);
    }

    private static final class Of<A>
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<A>
    implements Promise<A> {
        private final ListeningExecutorService delegateExecutor;

        public Of(ListenableFuture<A> delegate, ListeningExecutorService delegateExecutor) {
            super(delegate);
            this.delegateExecutor = delegateExecutor;
        }

        public A claim() {
            try {
                return (A)this.delegate().get();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        public Promise<A> done(Effect<? super A> e) {
            this.then(Promises.onSuccessDo(e));
            return this;
        }

        public Promise<A> fail(Effect<Throwable> e) {
            this.then(Promises.onFailureDo(e));
            return this;
        }

        public Promise<A> then(FutureCallback<? super A> callback) {
            Futures.addCallback((ListenableFuture)this.delegate(), callback, (Executor)this.delegateExecutor);
            return this;
        }

        public <B> Promise<B> map(Function<? super A, ? extends B> function) {
            return PromisingExecutorService.forListenableFuture(Futures.transform((ListenableFuture)this, function, (Executor)this.delegateExecutor), this.delegateExecutor);
        }

        public <B> Promise<B> flatMap(Function<? super A, ? extends Promise<? extends B>> f) {
            SettableFuture result = SettableFuture.create();
            Effect failResult = Promises.reject((SettableFuture)result);
            this.done(v -> {
                try {
                    Promise next = (Promise)f.apply(v);
                    next.done(t -> result.set(t)).fail(failResult);
                }
                catch (Throwable t2) {
                    result.setException(t2);
                }
            }).fail(failResult);
            return new Of<A>(result, this.delegateExecutor);
        }

        public Promise<A> recover(Function<Throwable, ? extends A> handleThrowable) {
            return this.fold(handleThrowable, Functions.identity());
        }

        public <B> Promise<B> fold(Function<Throwable, ? extends B> ft, Function<? super A, ? extends B> fa) {
            SettableFuture result = SettableFuture.create();
            Effect error = t -> {
                try {
                    result.set(ft.apply(t));
                }
                catch (Throwable inner) {
                    result.setException(inner);
                }
            };
            this.done(a -> {
                try {
                    result.set(fa.apply(a));
                }
                catch (Throwable t) {
                    error.apply((Object)t);
                }
            }).fail(error);
            return new Of<A>(result, this.delegateExecutor);
        }
    }
}

