/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.GoneException;
import com.atlassian.confluence.api.service.exceptions.InternalServerException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.api.model.RestError;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalApi
public class ExceptionConverter {
    private static final Logger log = LoggerFactory.getLogger(com.atlassian.confluence.rest.api.model.ExceptionConverter.class);

    public static class Client {
        public static ServiceException convertToServiceException(UniformInterfaceException e) {
            try {
                int status;
                ClientResponse response = e.getResponse();
                String message = "";
                ValidationResult validationResult = null;
                MediaType responseType = response.getType();
                if (responseType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    RestError error = (RestError)response.getEntity(RestError.class);
                    status = error.getStatusCode();
                    message = error.getMessage();
                    validationResult = error.getData();
                } else {
                    status = response.getStatus();
                    if (responseType.equals((Object)MediaType.TEXT_PLAIN_TYPE) || responseType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                        message = (String)response.getEntity(String.class);
                    }
                }
                switch (status) {
                    case 400: 
                    case 413: {
                        return validationResult != null ? new BadRequestException(message, validationResult) : new BadRequestException(message, (Throwable)e);
                    }
                    case 403: {
                        return validationResult != null ? new PermissionException(message, validationResult) : new PermissionException(message, (Throwable)e);
                    }
                    case 404: {
                        return validationResult != null ? new NotFoundException(message, validationResult) : new NotFoundException(message, (Throwable)e);
                    }
                    case 409: {
                        return validationResult != null ? new ConflictException(message, validationResult) : new ConflictException(message, (Throwable)e);
                    }
                    case 410: {
                        return validationResult != null ? new GoneException(message, validationResult) : new GoneException(message, (Throwable)e);
                    }
                    case 500: {
                        return validationResult != null ? new InternalServerException(message, validationResult) : new InternalServerException(message, (Throwable)e);
                    }
                    case 501: {
                        return validationResult != null ? new NotImplementedServiceException(message, validationResult) : new NotImplementedServiceException(message, (Exception)((Object)e));
                    }
                }
                return validationResult != null ? new ServiceException(message, validationResult) : new ServiceException(message, (Throwable)e);
            }
            catch (ClientHandlerException ex) {
                log.error("Could not convert RestError due to :" + ex.getMessage() + "\n Response entity from original exception : " + e.getResponse() + ", throwing original exception\nError Entity: " + (String)e.getResponse().getEntity(String.class));
                throw e;
            }
        }
    }
}

