/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.service.content.ContentDraftService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentDraftService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

public class RemoteContentDraftServiceImpl
extends AbstractRemoteService<ContentDraftService>
implements RemoteContentDraftService {
    public RemoteContentDraftServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Promise<Content> publishNewDraft(Content content, Expansion ... expansions) {
        WebResource resource = this.newContentWebResource().queryParam("status", ContentStatus.DRAFT.serialise());
        resource = this.addExpansions(resource, expansions);
        return this.postFuture(resource, Content.class, content);
    }

    @Override
    public Promise<Content> publishEditDraft(Content content, ContentDraftService.ConflictPolicy conflictPolicy) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise()).queryParam("status", ContentStatus.DRAFT.serialise());
        if (conflictPolicy != null) {
            resource = resource.queryParam("conflictPolicy", conflictPolicy.getValue());
        }
        return this.putFuture(resource, Content.class, content);
    }

    public WebResource newContentWebResource() {
        return this.newRestWebResource().path("content");
    }
}

