/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteCQLSearchService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import org.codehaus.jackson.map.ObjectMapper;

public class RemoteCQLSearchServiceImpl
extends AbstractRemoteService<CQLSearchService>
implements RemoteCQLSearchService {
    private static final String CQLCONTEXT_QUERY_PARAM = "cqlcontext";
    private static final String CQL_QUERY_PARAM = "cql";

    public RemoteCQLSearchServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Promise<PageResponse<Content>> searchContent(String cqlInput, SearchContext searchContext, PageRequest request, Expansion ... expansions) {
        WebResource resource = this.getContentSearchWebResource();
        if (searchContext != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                String serializedSearchContext = mapper.writeValueAsString((Object)searchContext);
                resource.queryParam(CQLCONTEXT_QUERY_PARAM, serializedSearchContext);
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
        resource = this.addExpansions(resource, expansions);
        if (request != null) {
            resource = this.addPageRequest(resource, request);
        }
        resource = resource.queryParam(CQL_QUERY_PARAM, cqlInput);
        return this.getFuturePageResponseList(resource, Content.class);
    }

    @Override
    public Promise<PageResponse<Content>> searchContent(String cql, PageRequest request, Expansion ... expansions) {
        return this.searchContent(cql, null, request, expansions);
    }

    @Override
    public Promise<PageResponse<Content>> searchContent(String cql, Expansion ... expansions) {
        return this.searchContent(cql, (PageRequest)null, expansions);
    }

    @Override
    public int countContent(String cql) {
        throw new NotImplementedServiceException("countContent not implemented by remoteService");
    }

    @Override
    public int countContent(String cql, SearchContext searchContext) {
        throw new NotImplementedServiceException("countContent not implemented by remoteService");
    }

    @Override
    public Promise<SearchPageResponse<SearchResult>> search(String cql, SearchOptions searchOptions, PageRequest pageRequest, Expansion ... expansions) {
        WebResource webResource = this.newRestWebResource().path("search");
        webResource = webResource.queryParam(CQL_QUERY_PARAM, cql);
        webResource = this.addPageRequestParams(webResource, pageRequest);
        webResource = this.addExpansions(webResource, expansions);
        webResource = webResource.queryParam("excerpt", searchOptions.getExcerptStrategy().serialise());
        webResource = webResource.queryParam("includeArchivedSpaces", Boolean.toString(searchOptions.isIncludeArchivedSpaces()));
        return this.getFuturePageResponseList(webResource, SearchResult.class).map(input -> SearchPageResponse.builder().result((Iterable)input).hasMore(input.hasMore()).build());
    }

    private WebResource getContentSearchWebResource() {
        return this.newRestWebResource().path("content").path("search");
    }
}

