/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

@ExperimentalApi
public class ExpansionsParser {
    public static Expansion[] parse(@Nullable String expand) {
        if (expand == null || expand.trim().isEmpty()) {
            return new Expansion[0];
        }
        return ExpansionsParser.parse(expand.split(",")).toArray();
    }

    public static Expansion[] parseExperimental(@Nullable String expand) {
        if (expand == null || expand.trim().isEmpty()) {
            return new Expansion[0];
        }
        return ExpansionsParser.parseExperimental(expand.split(",")).toArray();
    }

    public static Expansions parseAsExpansions(String expand) {
        return new Expansions(ExpansionsParser.parse(expand));
    }

    public static Expansions parseExperimentalAsExpansions(String expand) {
        return new Expansions(ExpansionsParser.parseExperimental(expand));
    }

    public static Expansion parseSingle(String expand) {
        Expansion[] expansions = ExpansionsParser.parse(expand);
        if (expansions.length > 0) {
            return expansions[0];
        }
        return new Expansion("");
    }

    public static Expansion parseExperimentalSingle(String expand) {
        Expansion[] expansions = ExpansionsParser.parseExperimental(expand);
        if (expansions.length > 0) {
            return expansions[0];
        }
        return new Expansion("");
    }

    public static String asString(Expansions expansions) {
        if (expansions == null) {
            return null;
        }
        return ExpansionsParser.asString(expansions.toArray());
    }

    public static String asString(Expansion[] expansionsArr) {
        return new ExpansionAsStringImpl().asString(expansionsArr);
    }

    public static Expansions parse(String ... individualExpansions) {
        return new ExpansionsParserImpl(false).parseExpansion(individualExpansions);
    }

    public static Expansions parseExperimental(String ... individualExpansions) {
        return new ExpansionsParserImpl(true).parseExpansion(individualExpansions);
    }

    public static Expansions parseWithPrefix(String prefix, String expansions) {
        Expansion[] subExpansions = ExpansionsParser.parse(expansions);
        return new Expansions(new Expansion[]{new Expansion(prefix, new Expansions(subExpansions))});
    }

    public static Expansions parseExperimentalWithPrefix(String prefix, String expansions) {
        Expansion[] subExpansions = ExpansionsParser.parseExperimental(expansions);
        return new Expansions(new Expansion[]{new Expansion(prefix, new Expansions(subExpansions))});
    }

    private static final class ExpansionAsStringImpl {
        private final Collection<String> parents;

        private ExpansionAsStringImpl() {
            this(new ArrayList<String>());
        }

        private ExpansionAsStringImpl(Collection<String> parents) {
            this.parents = parents;
        }

        private String asString(Expansion[] expansionsArr) {
            if (expansionsArr.length == 0) {
                return null;
            }
            ArrayList<String> expansionStrings = new ArrayList<String>();
            for (Expansion expansion : expansionsArr) {
                expansionStrings.add(this.asString(expansion));
            }
            expansionStrings.sort(null);
            return String.join((CharSequence)",", expansionStrings);
        }

        private String asString(Expansion expansion) {
            String propertyName = expansion.getPropertyName();
            Expansions subExpansions = expansion.getSubExpansions();
            ArrayList<String> pathParts = new ArrayList<String>(this.parents);
            pathParts.add(propertyName);
            if (subExpansions.isEmpty()) {
                return String.join((CharSequence)".", pathParts);
            }
            return new ExpansionAsStringImpl(pathParts).asString(subExpansions.toArray());
        }
    }

    private static final class ExpansionsParserImpl {
        private static final Set<String> EXPERIMENTAL_EXPANSIONS = Collections.emptySet();
        private final boolean allowExperimental;

        private ExpansionsParserImpl(boolean allowExperimental) {
            this.allowExperimental = allowExperimental;
        }

        private Expansions parseExpansion(String ... individualExpansions) {
            return new Expansions((Iterable)Arrays.stream(individualExpansions).flatMap(individualExpansion -> this.toExpansion((String)individualExpansion).stream()).collect(Collectors.toList()));
        }

        private Collection<Expansion> toExpansion(String individualExpansion) {
            String[] pathParts = individualExpansion.split("\\.");
            return this.toExpansion(pathParts);
        }

        private Collection<Expansion> toExpansion(String ... pathDotParts) {
            String pathStart = pathDotParts[0];
            if (!this.allowExperimental && EXPERIMENTAL_EXPANSIONS.contains(pathStart)) {
                return Collections.emptyList();
            }
            if (pathDotParts.length == 1) {
                return Collections.singleton(new Expansion(pathStart));
            }
            Collection<Expansion> subExpansions = this.toExpansion(this.rest(pathDotParts));
            return Collections.singleton(new Expansion(pathStart, new Expansions(subExpansions)));
        }

        private String[] rest(String[] pathParts) {
            return Arrays.copyOfRange(pathParts, 1, pathParts.length);
        }
    }
}

