/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.service.pagination;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.SpaceCursor;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CursorFactory {
    private static final Map<String, Function<String, Cursor>> cursorInstanceCreators = new ConcurrentHashMap<String, Function<String, Cursor>>();
    private static final Map<ContentType, Cursor> contentTypeToEmptyCursor = new HashMap<ContentType, Cursor>();

    private CursorFactory() {
    }

    public static void registerCursorInstanceCreator(String cursorType, Function<String, Cursor> function) {
        cursorInstanceCreators.put(cursorType, function);
    }

    public static Cursor buildFrom(String cursorString) {
        if (cursorString == null || cursorString.isEmpty()) {
            return null;
        }
        int firstColonIndex = cursorString.indexOf(":");
        if (firstColonIndex < 0) {
            throw new BadRequestException(String.format("Format of cursor %s is not supported. At least one colon ':' is expected", cursorString));
        }
        String cursorTypeString = cursorString.substring(0, firstColonIndex);
        try {
            return cursorInstanceCreators.getOrDefault(cursorTypeString, cursor -> {
                throw new IllegalArgumentException("Cursor type " + cursorTypeString + " is not supported");
            }).apply(cursorString);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(String.format("Invalid cursor type '%s'", cursorTypeString), e);
        }
    }

    public static Cursor getEmptyCursorBy(ContentType contentType) {
        if (contentTypeToEmptyCursor.containsKey(contentType)) {
            return contentTypeToEmptyCursor.get(contentType);
        }
        return ContentCursor.EMPTY_CURSOR;
    }

    static {
        CursorFactory.registerCursorInstanceCreator(CursorType.SPACE.getType(), SpaceCursor::valueOf);
        CursorFactory.registerCursorInstanceCreator(CursorType.CONTENT.getType(), ContentCursor::valueOf);
        CursorFactory.registerCursorInstanceCreator(CursorType.BLOG_POST.getType(), ContentCursor::valueOf);
        CursorFactory.registerCursorInstanceCreator(CursorType.COMMENT.getType(), ContentCursor::valueOf);
        CursorFactory.registerCursorInstanceCreator(CursorType.ATTACHMENT.getType(), ContentCursor::valueOf);
        contentTypeToEmptyCursor.put(ContentType.PAGE, ContentCursor.EMPTY_CURSOR);
        contentTypeToEmptyCursor.put(ContentType.BLOG_POST, ContentCursor.EMPTY_BLOGPOST_CURSOR);
        contentTypeToEmptyCursor.put(ContentType.COMMENT, ContentCursor.EMPTY_COMMENT_CURSOR);
        contentTypeToEmptyCursor.put(ContentType.ATTACHMENT, ContentCursor.EMPTY_ATTACHMENT_CURSOR);
    }
}

