/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.service.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.finder.ManyFetcher;
import com.atlassian.confluence.api.service.finder.SingleFetcher;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SpaceService {
    public Space create(Space var1, boolean var2) throws ServiceException;

    public Space update(Space var1) throws ServiceException;

    public SpaceFinder find(Expansion ... var1);

    @Deprecated
    public PageResponse<Label> findAllContentLabelsPaginated(String var1, PageRequest var2);

    @Deprecated
    public PageResponse<Label> findPopularContentLabelsPaginated(String var1, PageRequest var2);

    @Deprecated
    public PageResponse<Label> findRecentContentLabelsPaginated(String var1, PageRequest var2);

    @Deprecated
    public PageResponse<Label> findRelatedContentLabelsPaginated(String var1, String var2, PageRequest var3);

    public void archive(String var1);

    public void restore(String var1);

    public void emptyTrash(String var1) throws ServiceException;

    public SpaceContentFinder findContent(Space var1, Expansion ... var2) throws NotFoundException;

    public LongTaskSubmission delete(Space var1) throws ServiceException;

    @ExperimentalApi
    public void delete(long var1) throws ServiceException;

    @ExperimentalApi
    public void deleteSynchronously(long var1) throws ServiceException;

    public Validator validator();

    public static interface Validator {
        public ValidationResult validateGet(String var1);

        public ValidationResult validateCreate(Space var1, boolean var2);

        public ValidationResult validateUpdate(Space var1);

        public ValidationResult validateDelete(Space var1);

        public ValidationResult validateArchive(Space var1);

        public ValidationResult validateRestore(Space var1);

        public ValidationResult validateEmptyTrash(String var1);
    }

    public static interface SpaceContentFinder {
        public SpaceContentFinder withDepth(Depth var1);

        public Map<ContentType, PageResponse<Content>> fetchMappedByType(PageRequest var1) throws BadRequestException, NotFoundException;

        public PageResponse<Content> fetchMany(ContentType var1, PageRequest var2) throws BadRequestException, NotFoundException;
    }

    public static interface SingleSpaceFetcher
    extends SingleFetcher<Space> {
    }

    public static interface SpaceFinder
    extends SingleSpaceFetcher,
    ManyFetcher<Space> {
        public SpaceFinder withKeys(String ... var1);

        public SpaceFinder withIds(Set<Long> var1);

        public SpaceFinder withType(SpaceType var1);

        public SpaceFinder withStatus(SpaceStatus var1);

        public SpaceFinder withLabels(Label ... var1);

        public SpaceFinder withContentContainingLabels(List<String> var1);

        public SpaceFinder withIsFavourited(boolean var1);

        public SpaceFinder withHasRetentionPolicy(boolean var1);
    }
}

