/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.web;

import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.graphql.annotations.GraphQLIDType;
import com.atlassian.graphql.annotations.GraphQLTypeName;
import com.atlassian.soy.renderer.CustomSoyDataMapper;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@CustomSoyDataMapper(value="jackson2soy")
@GraphQLTypeName(value="WebSection")
public class WebSectionView {
    @JsonProperty
    @GraphQLIDType
    private final String id;
    @JsonProperty
    private final String label;
    @JsonProperty
    private final List<WebItemView> items;
    @JsonProperty
    private final String styleClass;

    @JsonCreator
    protected WebSectionView(@JsonProperty(value="id") String id, @JsonProperty(value="label") String label, @JsonProperty(value="items") List<WebItemView> items, @JsonProperty(value="styleClass") String styleClass) {
        this.id = id;
        this.label = label;
        this.items = Collections.unmodifiableList(new ArrayList<WebItemView>(items));
        this.styleClass = styleClass;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public Iterable<WebItemView> getLinks() {
        return this.items;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<WebItemView> items = new ArrayList<WebItemView>();
        private String styleClass;

        public Builder setStyleClass(String styleClass) {
            this.styleClass = styleClass;
            return this;
        }

        public Builder addItems(WebItemView ... items) {
            this.items.addAll(Arrays.asList(items));
            return this;
        }

        public Builder addItems(Iterable<WebItemView> items) {
            items.forEach(this.items::add);
            return this;
        }

        public WebSectionView create(String id, String label) {
            WebSectionView section = new WebSectionView(id, label, this.items, this.styleClass);
            return section;
        }
    }
}

