/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.retention;

import com.atlassian.confluence.api.model.retention.RemovalSummary;
import com.atlassian.confluence.api.model.retention.SoftCleanupJobStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FastSoftCleanupJobStatus
extends SoftCleanupJobStatus {
    public static final Long GLOBAL_SPACE_ID = -1L;
    @JsonProperty
    private Map<Long, Long> spacePageNextStartOriginalIds = new HashMap<Long, Long>();
    @JsonProperty
    private Map<Long, Long> spaceAttachmentNextStartOriginalIds = new HashMap<Long, Long>();

    @JsonCreator
    public FastSoftCleanupJobStatus(@JsonProperty(value="overall") RemovalSummary overall, @JsonProperty(value="currentCycle") RemovalSummary currentCycle, @JsonProperty(value="lastIteration") RemovalSummary lastIteration, @JsonProperty(value="cyclesCompleted") int cyclesCompleted, @JsonProperty(value="iterationsCompleted") int iterationsCompleted, @JsonProperty(value="nextStartOriginalId") long nextStartOriginalId, @JsonProperty(value="spacePageNextStartOriginalIds") Map<Long, Long> spacePageNextStartOriginalIds, @JsonProperty(value="spaceAttachmentNextStartOriginalIds") Map<Long, Long> spaceAttachmentNextStartOriginalIds) {
        super(overall, currentCycle, lastIteration, cyclesCompleted, iterationsCompleted, nextStartOriginalId);
        this.spacePageNextStartOriginalIds = new HashMap<Long, Long>(spacePageNextStartOriginalIds);
        this.spaceAttachmentNextStartOriginalIds = new HashMap<Long, Long>(spaceAttachmentNextStartOriginalIds);
    }

    public FastSoftCleanupJobStatus() {
    }

    public long getSpacePageNextStartOriginalId(long policySpaceId) {
        return this.spacePageNextStartOriginalIds.getOrDefault(policySpaceId, 0L);
    }

    public long getSpaceAttachmentNextStartOriginalId(long policySpaceId) {
        return this.spaceAttachmentNextStartOriginalIds.getOrDefault(policySpaceId, 0L);
    }

    public void setSpacePageNextStartOriginalId(long policySpaceId, long nextStartOriginalId) {
        this.spacePageNextStartOriginalIds.put(policySpaceId, nextStartOriginalId);
    }

    public void setSpaceAttachmentNextStartOriginalId(long policySpaceId, long nextStartOriginalId) {
        this.spaceAttachmentNextStartOriginalIds.put(policySpaceId, nextStartOriginalId);
    }

    public static FastSoftCleanupJobStatusBuilder builder() {
        return new FastSoftCleanupJobStatusBuilder();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FastSoftCleanupJobStatus)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FastSoftCleanupJobStatus that = (FastSoftCleanupJobStatus)obj;
        return Objects.equals(this.spacePageNextStartOriginalIds, that.spacePageNextStartOriginalIds) && Objects.equals(this.spaceAttachmentNextStartOriginalIds, that.spaceAttachmentNextStartOriginalIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getOverall(), this.getCurrentCycle(), this.getIterationsCompleted(), this.getCyclesCompleted(), this.getLastIteration(), this.getNextStartOriginalId(), this.spacePageNextStartOriginalIds, this.spaceAttachmentNextStartOriginalIds);
    }

    @Override
    public String toString() {
        return "FastSoftCleanupJobStatus{overall=" + this.getOverall() + ", currentCycle=" + this.getCurrentCycle() + ", lastIteration=" + this.getLastIteration() + ", cycles=" + this.getCyclesCompleted() + ", iterationsCompleted=" + this.getIterationsCompleted() + ", nextStartOriginalId=" + this.getNextStartOriginalId() + ", spacePageNextStartOriginalIds=" + this.spacePageNextStartOriginalIds.toString() + ", spaceAttachmentNextStartOriginalIds=" + this.spaceAttachmentNextStartOriginalIds.toString() + '}';
    }

    public static class FastSoftCleanupJobStatusBuilder
    extends SoftCleanupJobStatus.SoftCleanupJobStatusBuilder {
        private Map<Long, Long> spacePageNextStartOriginalIds = new HashMap<Long, Long>();
        private Map<Long, Long> spaceAttachmentNextStartOriginalIds = new HashMap<Long, Long>();

        public FastSoftCleanupJobStatusBuilder spacePageNextStartOriginalIds(Map<Long, Long> spacePageNextStartOriginalIds) {
            this.spacePageNextStartOriginalIds = new HashMap<Long, Long>(spacePageNextStartOriginalIds);
            return this;
        }

        public FastSoftCleanupJobStatusBuilder spaceAttachmentNextStartOriginalIds(Map<Long, Long> spaceAttachmentNextStartOriginalIds) {
            this.spaceAttachmentNextStartOriginalIds = new HashMap<Long, Long>(spaceAttachmentNextStartOriginalIds);
            return this;
        }

        @Override
        public FastSoftCleanupJobStatus build() {
            return new FastSoftCleanupJobStatus(this.overall, this.currentCycle, this.lastIteration, this.cyclesCompleted, this.iterationsCompleted, this.nextStartOriginalId, this.spacePageNextStartOriginalIds, this.spaceAttachmentNextStartOriginalIds);
        }
    }
}

