/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.people;

import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.serialization.SwaggerEnrichExpandable;
import com.atlassian.confluence.api.serialization.SwaggerEnrichLinks;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@SwaggerEnrichLinks
@SwaggerEnrichExpandable
public class User
extends Person
implements Relatable {
    @JsonProperty
    @Schema(example="user1")
    protected final String username;
    @JsonProperty
    @Schema(example="userkey[admin]")
    private final String userKey;

    @JsonCreator
    public User(@JsonProperty(value="userkey") String userKey) {
        super(Reference.collapsed(Icon.class), "");
        this.username = null;
        this.userKey = userKey;
    }

    @JsonCreator
    private User() {
        this("");
    }

    public User(Reference<Icon> profilePicture, String username, String displayName, String userKey) {
        super(profilePicture, displayName);
        this.username = username;
        this.userKey = userKey != null ? userKey : "";
    }

    public User(Icon profilePicture, String username, String displayName, String userKey) {
        super(profilePicture, displayName);
        this.username = username;
        this.userKey = userKey != null ? userKey : "";
    }

    public User(String username, String displayName, UserKey userKey, Reference<Icon> profilePicture) {
        this(profilePicture, username, displayName, userKey != null ? userKey.getStringValue() : "");
    }

    public User(Icon profilePicture, String username, String displayName, UserKey userKey) {
        this(profilePicture, username, displayName, userKey != null ? userKey.getStringValue() : "");
    }

    @Deprecated
    public User(Icon profilePicture, String username) {
        super(profilePicture);
        this.username = username;
        this.userKey = null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getUserKey() {
        return this.optionalUserKey().orElse(new UserKey("")).getStringValue();
    }

    @Override
    public Optional<String> optionalUsername() {
        if (this.getUsername() == null || this.getUsername().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getUsername());
    }

    @Override
    @JsonIgnore
    public Optional<UserKey> optionalUserKey() {
        if (this.userKey == null || this.userKey.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new UserKey(this.userKey));
    }

    public String toString() {
        return "User{username='" + this.username + '\'' + ", userKey='" + this.userKey + '\'' + '}';
    }

    public static User fromUsername(String username) {
        return new User(null, username);
    }

    public static User fromUserkey(UserKey key) {
        return new User(null, null, key, Reference.empty(Icon.class));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.username, user.username) && Objects.equals(this.userKey, user.userKey);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.userKey);
    }

    public static class Expansions {
        public static final String STATUS = "status";
        public static final String PROFILE_PICTURE = "profilePicture";
        public static final String LAST_LOGIN = "lastLogin";
    }
}

