/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.pagination;

import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.CursorType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ContentCursor
implements Cursor {
    private final boolean isReverse;
    private final Long contentId;
    private final CursorType cursorType;
    private static final Set<CursorType> SUPPORTED_CURSOR_TYPE = new HashSet<CursorType>();
    public static final ContentCursor EMPTY_CURSOR;
    public static final ContentCursor EMPTY_CURSOR_PREV;
    public static final ContentCursor EMPTY_BLOGPOST_CURSOR;
    public static final ContentCursor EMPTY_BLOGPOST_CURSOR_PREV;
    public static final ContentCursor EMPTY_COMMENT_CURSOR;
    public static final ContentCursor EMPTY_ATTACHMENT_CURSOR;

    private ContentCursor(boolean isReverse, Long contentId) {
        this.isReverse = isReverse;
        this.contentId = contentId;
        this.cursorType = CursorType.CONTENT;
    }

    private ContentCursor(boolean isReverse, Long contentId, CursorType cursorType) {
        this.isReverse = isReverse;
        this.contentId = contentId;
        this.cursorType = cursorType;
    }

    public static ContentCursor createCursor(boolean isReverse, long contentId) {
        return new ContentCursor(isReverse, contentId, CursorType.CONTENT);
    }

    public static ContentCursor createCursor(boolean isReverse, long contentId, CursorType cursorType) {
        return new ContentCursor(isReverse, contentId, cursorType);
    }

    @Override
    public CursorType getCursorType() {
        return this.cursorType;
    }

    @Override
    public boolean isReverse() {
        return this.isReverse;
    }

    public Long getContentId() {
        return this.contentId;
    }

    @Override
    public boolean isEmpty() {
        return this.equals(EMPTY_CURSOR) || this.equals(EMPTY_CURSOR_PREV);
    }

    public String toString() {
        return String.join((CharSequence)":", this.getCursorType().getType(), String.valueOf(this.isReverse), String.valueOf(this.contentId));
    }

    public static ContentCursor valueOf(@NonNull String cursorToken) {
        try {
            String[] cursorArray = cursorToken.split(":");
            if (cursorArray.length != 3) {
                throw new IllegalArgumentException(String.format("Illegal cursor value %s. Cursor needs to be in the next format: 'cursorType:isReverse:contentId'", cursorToken));
            }
            CursorType cursorType = CursorType.getCursorType(cursorArray[0]);
            if (cursorType == null || !SUPPORTED_CURSOR_TYPE.contains((Object)cursorType)) {
                throw new IllegalArgumentException("Illegal cursor type. Supported cursor types are " + SUPPORTED_CURSOR_TYPE.stream().map(Enum::name).collect(Collectors.joining(",")));
            }
            boolean isReverse = Boolean.parseBoolean(cursorArray[1]);
            Long contentId = cursorArray[2].equalsIgnoreCase("null") ? null : Long.valueOf(Long.parseLong(cursorArray[2]));
            return new ContentCursor(isReverse, contentId, cursorType);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Illegal cursor value %s. Cursor needs to be in the next format: 'cursorType:isReverse:contentId'", cursorToken), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentCursor)) {
            return false;
        }
        ContentCursor that = (ContentCursor)o;
        return this.isReverse == that.isReverse && Objects.equals(this.contentId, that.contentId);
    }

    public int hashCode() {
        return Objects.hash(this.isReverse, this.contentId);
    }

    static {
        SUPPORTED_CURSOR_TYPE.add(CursorType.CONTENT);
        SUPPORTED_CURSOR_TYPE.add(CursorType.BLOG_POST);
        SUPPORTED_CURSOR_TYPE.add(CursorType.COMMENT);
        SUPPORTED_CURSOR_TYPE.add(CursorType.ATTACHMENT);
        EMPTY_CURSOR = new ContentCursor(false, null);
        EMPTY_CURSOR_PREV = new ContentCursor(true, null);
        EMPTY_BLOGPOST_CURSOR = new ContentCursor(false, null, CursorType.BLOG_POST);
        EMPTY_BLOGPOST_CURSOR_PREV = new ContentCursor(true, null, CursorType.BLOG_POST);
        EMPTY_COMMENT_CURSOR = new ContentCursor(false, null, CursorType.COMMENT);
        EMPTY_ATTACHMENT_CURSOR = new ContentCursor(false, null, CursorType.ATTACHMENT);
    }
}

