/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.backuprestore;

import com.atlassian.confluence.api.model.backuprestore.JobDetails;
import com.atlassian.confluence.api.model.backuprestore.JobStatistics;
import com.atlassian.confluence.api.model.backuprestore.SpaceBackupSettings;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SpaceBackupJobDetails
extends JobDetails {
    @JsonProperty
    private SpaceBackupSettings jobSettings;
    @JsonProperty
    private JobStatistics statistics;

    public SpaceBackupJobDetails() {
        super(SpaceBackupJobDetails.builder());
    }

    private SpaceBackupJobDetails(SpaceBackupJobDetailsBuilder builder) {
        super(builder);
        this.jobSettings = builder.jobSettings;
        this.statistics = builder.statistics;
    }

    public SpaceBackupSettings getJobSettings() {
        return this.jobSettings;
    }

    public JobStatistics getJobStatistics() {
        return this.statistics;
    }

    public void setJobSettings(SpaceBackupSettings jobSettings) {
        this.jobSettings = jobSettings;
    }

    public void setJobStatistics(JobStatistics jobStatistics) {
        this.statistics = jobStatistics;
    }

    public static SpaceBackupJobDetailsBuilder builder() {
        return new SpaceBackupJobDetailsBuilder();
    }

    public static class SpaceBackupJobDetailsBuilder
    extends JobDetails.JobDetailsBuilder {
        private SpaceBackupSettings jobSettings;
        private JobStatistics statistics;

        public SpaceBackupJobDetailsBuilder jobSettings(SpaceBackupSettings jobSettings) {
            this.jobSettings = new SpaceBackupSettings(jobSettings.getSpaceKeys(), jobSettings.isKeepPermanently(), jobSettings.getFileNamePrefix());
            return this;
        }

        public SpaceBackupJobDetailsBuilder jobStatistics(JobStatistics jobStatistics) {
            this.statistics = new JobStatistics(jobStatistics.getTotalObjectsCount(), jobStatistics.getProcessedObjectsCount(), jobStatistics.getPersistedObjectsCount(), jobStatistics.getSkippedObjectsCount(), jobStatistics.getReusedObjectsCount());
            return this;
        }

        @Override
        public SpaceBackupJobDetails build() {
            return new SpaceBackupJobDetails(this);
        }
    }
}

