/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.longtasks;

import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LongTaskId {
    @Schema(example="123e4567-e89b-12d3-a456-426614174000")
    private final UUID uuid;

    private LongTaskId(UUID uuid) {
        this.uuid = uuid;
    }

    @JsonCreator
    public static LongTaskId deserialise(String id) {
        if (id == null || id.isEmpty()) {
            throw new BadRequestException("LongTaskId string must not be null or empty: " + id);
        }
        return new LongTaskId(UUID.fromString(id));
    }

    @JsonValue
    public String serialise() {
        return String.valueOf(this.uuid);
    }

    public boolean equals(Object other) {
        if (other instanceof LongTaskId) {
            return Objects.equals(this.uuid, ((LongTaskId)other).uuid);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

