/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.soy.renderer.CustomSoyDataMapper;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@CustomSoyDataMapper(value="jackson2soy")
public final class ContentType
extends BaseApiEnum {
    public static final ContentType PAGE = new ContentType("page");
    public static final ContentType BLOG_POST = new ContentType("blogpost");
    public static final ContentType COMMENT = new ContentType("comment");
    public static final ContentType ATTACHMENT = new ContentType("attachment");
    public static final List<ContentType> BUILT_IN = Collections.unmodifiableList(Arrays.asList(PAGE, BLOG_POST, COMMENT, ATTACHMENT));

    @JsonCreator
    @Schema(example="page")
    public static ContentType valueOf(String type) {
        for (ContentType contentType : BUILT_IN) {
            if (!type.equals(contentType.getType())) continue;
            return contentType;
        }
        return new ContentType(type);
    }

    @Schema(example="[\"page\", \"blogpost\"]")
    public static Set<ContentType> valuesOf(Iterable<String> types) {
        return StreamSupport.stream(types.spliterator(), false).map(ContentType::valueOf).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    @JsonIgnore
    private ContentType(String type) {
        super(type);
    }

    public String getType() {
        return this.serialise();
    }
}

