/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.content.ContainerMap;
import com.atlassian.confluence.api.model.reference.Reference;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@Internal
public class InternalJackson2Deserializers {
    private InternalJackson2Deserializers() {
    }

    static class ContainerMapDeserializer
    extends JsonDeserializer<Reference<ContainerMap>> {
        ContainerMapDeserializer() {
        }

        public Reference<ContainerMap> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ContainerMap results = new ContainerMap();
            JsonNode node = (JsonNode)jsonParser.readValueAsTree();
            node.fields().forEachRemaining(field -> {
                JsonNode fieldValue = (JsonNode)field.getValue();
                if (!fieldValue.isObject()) {
                    String key = (String)field.getKey();
                    String value = fieldValue.asText();
                    results.put(key, value);
                }
            });
            return Reference.to(results);
        }
    }
}

