/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.people;

import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.SubjectType;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.graphql.annotations.GraphQLTypeName;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@org.codehaus.jackson.annotate.JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=User.class, name="user"), @JsonSubTypes.Type(value=UnknownUser.class, name="unknown"), @JsonSubTypes.Type(value=KnownUser.class, name="known"), @JsonSubTypes.Type(value=Anonymous.class, name="anonymous")})
@org.codehaus.jackson.annotate.JsonSubTypes(value={@JsonSubTypes.Type(value=User.class, name="user"), @JsonSubTypes.Type(value=UnknownUser.class, name="unknown"), @JsonSubTypes.Type(value=KnownUser.class, name="known"), @JsonSubTypes.Type(value=Anonymous.class, name="anonymous")})
@JsonIgnoreProperties(ignoreUnknown=true)
@org.codehaus.jackson.annotate.JsonIgnoreProperties(ignoreUnknown=true)
@GraphQLTypeName(value="User")
public abstract class Person
implements Subject {
    protected static final String KNOWN_USER_TYPE = "known";
    protected static final String ANONYMOUS_USER_TYPE = "anonymous";
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema
    private final Icon profilePicture;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="Joe Smith")
    private final String displayName;

    protected Person(Icon profilePicture, String displayName) {
        this.profilePicture = profilePicture;
        this.displayName = displayName;
    }

    protected Person(PersonBuilder personBuilder) {
        this.profilePicture = personBuilder.profilePicture;
        this.displayName = personBuilder.displayName;
    }

    @Deprecated
    protected Person(Icon profilePicture) {
        this(profilePicture, "");
    }

    public Icon getProfilePicture() {
        return this.profilePicture;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public abstract Optional<String> optionalUsername();

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public abstract Optional<UserKey> optionalUserKey();

    @Override
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public SubjectType getSubjectType() {
        return SubjectType.USER;
    }

    public static abstract class PersonBuilder<T extends PersonBuilder<T>> {
        protected String displayName;
        protected Icon profilePicture;

        public T displayName(String displayName) {
            this.displayName = displayName;
            return this.self();
        }

        public T profilePicture(Icon profilePicture) {
            this.profilePicture = profilePicture;
            return this.self();
        }

        protected abstract T self();

        public abstract Person build();
    }
}

