/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.longtasks;

import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonValue;

@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LongTaskId {
    @Schema(example="123e4567-e89b-12d3-a456-426614174000")
    private final UUID uuid;

    private LongTaskId(UUID uuid) {
        this.uuid = uuid;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    @JsonCreator
    public static LongTaskId deserialise(String id) {
        if (id == null || id.isEmpty()) {
            throw new BadRequestException("LongTaskId string must not be null or empty: " + id);
        }
        return new LongTaskId(UUID.fromString(id));
    }

    @com.fasterxml.jackson.annotation.JsonValue
    @JsonValue
    public String serialise() {
        return String.valueOf(this.uuid);
    }

    public boolean equals(Object other) {
        if (other instanceof LongTaskId) {
            return Objects.equals(this.uuid, ((LongTaskId)other).uuid);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

