/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansion;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ExperimentalApi
public class Expansions {
    private static final Pattern KEY_MATCH_PATTERN = Pattern.compile("^(.+?)(\\[.*?\\])?$");
    public static final Expansions EMPTY = new Expansions(Collections.emptyMap());
    private final Map<String, Expansions> expansionsMap;

    public Expansions(Expansion ... expansions) {
        this(Expansions.merge(new HashMap<String, Expansions>(), expansions));
    }

    public Expansions(Iterable<Expansion> expansions) {
        this(Expansions.toArray(expansions));
    }

    private static Expansion[] toArray(Iterable<Expansion> expansions) {
        Expansion[] array = (Expansion[])Iterables.toArray(expansions, Expansion.class);
        return array == null ? new Expansion[]{} : array;
    }

    public static Expansions of(String ... expansionStr) {
        return new Expansions(Collections2.transform(Arrays.asList(expansionStr), Expansion.AS_EXPANSION).toArray(new Expansion[0]));
    }

    public Expansions merge(Expansions expansions) {
        return new Expansions(Expansions.merge(this.expansionsMap, expansions.toArray()));
    }

    public Expansion[] merge(Expansion[] expansions) {
        return new Expansions(Expansions.merge(this.expansionsMap, expansions)).toArray();
    }

    private Expansions(Map<String, Expansions> expansionsMap) {
        this.expansionsMap = ImmutableMap.copyOf(expansionsMap);
    }

    private static Map<String, Expansions> merge(Map<String, Expansions> existingMap, Expansion ... incomingExpansions) {
        HashMap<String, Expansions> mutableExistingMap = new HashMap<String, Expansions>(existingMap);
        for (Expansion incomingExpansion : incomingExpansions) {
            Expansions incomingSubExpansions;
            Expansions mergedSubExpansions = incomingSubExpansions = incomingExpansion.getSubExpansions();
            String name = incomingExpansion.getPropertyName();
            Expansions existingSubExpansions = (Expansions)mutableExistingMap.get(name);
            if (existingSubExpansions != null) {
                Map<String, Expansions> mergedMap = Expansions.merge(existingSubExpansions.expansionsMap, incomingSubExpansions.toArray());
                mergedSubExpansions = new Expansions(mergedMap);
                mutableExistingMap.put(Expansions.encode(name), mergedSubExpansions);
            }
            mutableExistingMap.put(Expansions.encode(name), mergedSubExpansions);
        }
        return mutableExistingMap;
    }

    public boolean canExpand(String propertyName) {
        if (this.expansionsMap.containsKey(propertyName)) {
            return true;
        }
        return this.expansionsMap.containsKey(Expansions.encode(propertyName));
    }

    public Expansions getSubExpansions(String propertyName) {
        if (this.canExpand(propertyName)) {
            if (this.expansionsMap.containsKey(propertyName)) {
                return this.expansionsMap.get(propertyName);
            }
            return this.expansionsMap.get(Expansions.encode(propertyName));
        }
        return EMPTY;
    }

    public Expansions prepend(String propertyName) {
        return new Expansions(new Expansion(propertyName, this));
    }

    public Expansion[] toArray() {
        Expansion[] array = new Expansion[this.expansionsMap.size()];
        int i = 0;
        for (Map.Entry<String, Expansions> stringExpansionsEntry : this.expansionsMap.entrySet()) {
            array[i++] = new Expansion(stringExpansionsEntry.getKey(), stringExpansionsEntry.getValue());
        }
        return array;
    }

    public boolean isEmpty() {
        return this.expansionsMap.isEmpty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("map", this.expansionsMap).toString();
    }

    public void checkRecursiveExpansion(String expansion) {
        if (this.canExpand(expansion)) {
            throw new IllegalArgumentException("Cannot recursively expand : " + expansion);
        }
        for (Expansions exp : this.expansionsMap.values()) {
            exp.checkRecursiveExpansion(expansion);
        }
    }

    public static String encode(String expand) {
        if (expand == null) {
            return null;
        }
        Matcher matcher = KEY_MATCH_PATTERN.matcher(expand);
        if (matcher.matches()) {
            String expandName = matcher.group(1);
            String indexes = matcher.group(2);
            if (indexes == null) {
                return Expansions.encodeExpandName(expandName);
            }
            return Expansions.encodeExpandName(expandName) + indexes;
        }
        return expand;
    }

    private static String encodeExpandName(String expandName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expandName.length(); ++i) {
            char c = expandName.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '*') {
                sb.append(c);
                continue;
            }
            if (c == ':') {
                sb.append("__");
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expansions that = (Expansions)o;
        return Objects.equals(this.expansionsMap, that.expansionsMap);
    }

    public int hashCode() {
        return Objects.hash(this.expansionsMap);
    }
}

