/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.service.exceptions;

import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;

public class InvalidRepresentationException
extends RuntimeException {
    private final Collection<ContentRepresentation> permittedRepresentations;

    public InvalidRepresentationException(ContentRepresentation unacceptableRepresentation, ContentRepresentation[] permittedRepresentations) {
        super("Unacceptable content representation : " + unacceptableRepresentation + ". Allowed representations: " + Arrays.toString(permittedRepresentations));
        this.permittedRepresentations = ImmutableList.copyOf((Object[])permittedRepresentations);
    }

    public InvalidRepresentationException(ContentRepresentation representation, Iterable<ContentRepresentation> contentRepresentations) {
        this(representation, (ContentRepresentation[])Iterables.toArray(contentRepresentations, ContentRepresentation.class));
    }

    public Iterable<ContentRepresentation> getPermittedRepresentations() {
        return this.permittedRepresentations;
    }
}

