/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content.template;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintId;
import com.atlassian.confluence.api.model.content.template.ContentTemplateId;
import com.atlassian.confluence.api.model.content.template.ContentTemplateType;
import com.atlassian.confluence.api.model.plugin.ModuleCompleteKey;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.fugue.Option;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class ContentTemplate
implements NavigationAware {
    @JsonProperty
    private final ContentTemplateId templateId;
    @JsonProperty
    private final Option<ModuleCompleteKey> originalTemplate;
    @JsonProperty
    private final Option<ContentBlueprintId> referencingBlueprint;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final Option<Space> space;
    @JsonProperty
    private final List<Label> labels;
    @JsonProperty
    private final ContentTemplateType templateType;
    @JsonDeserialize(as=EnrichableMap.class)
    @JsonProperty
    private final Map<ContentRepresentation, ContentBody> body;

    public Map<ContentRepresentation, ContentBody> getBody() {
        return this.body;
    }

    public ContentTemplateId getTemplateId() {
        return this.templateId;
    }

    public Option<ModuleCompleteKey> getOriginalTemplate() {
        return this.originalTemplate;
    }

    public Option<ContentBlueprintId> getReferencingBlueprint() {
        return this.referencingBlueprint;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Option<Space> getSpace() {
        return this.space;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public ContentTemplateType getTemplateType() {
        return this.templateType;
    }

    @JsonCreator
    private ContentTemplate() {
        this(ContentTemplate.builder());
    }

    private ContentTemplate(ContentTemplateBuilder builder) {
        this.templateId = builder.templateId;
        this.originalTemplate = builder.originalTemplate;
        this.referencingBlueprint = builder.referencingBlueprint;
        this.name = builder.name;
        this.description = builder.description;
        this.space = Option.option((Object)builder.space);
        this.body = BuilderUtils.modelMap(builder.bodyMapBuilder);
        this.labels = builder.labelsBuilder.build();
        this.templateType = builder.templateType;
    }

    public static ContentTemplateBuilder builder() {
        return new ContentTemplateBuilder();
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().experimental().template(this);
    }

    public static class Expansions {
        public static final String BODY = "body";
    }

    public static class ContentTemplateBuilder {
        private ModelMapBuilder<ContentRepresentation, ContentBody> bodyMapBuilder = ModelMapBuilder.newInstance();
        private ContentTemplateId templateId;
        private Option<ModuleCompleteKey> originalTemplate = Option.none();
        private Option<ContentBlueprintId> referencingBlueprint = Option.none();
        private String name = "";
        private String description = "";
        private Space space;
        private ImmutableList.Builder<Label> labelsBuilder = ImmutableList.builder();
        private ContentTemplateType templateType;

        private ContentTemplateBuilder() {
        }

        public ContentTemplateBuilder body(Map<ContentRepresentation, ContentBody> body) {
            this.bodyMapBuilder.copy(body);
            return this;
        }

        public ContentTemplateBuilder body(ContentBody body) {
            this.bodyMapBuilder.put(body.getRepresentation(), body);
            return this;
        }

        public ContentTemplateBuilder templateId(ContentTemplateId templateId) {
            this.templateId = templateId;
            return this;
        }

        public ContentTemplateBuilder originalTemplate(ModuleCompleteKey originalTemplate) {
            this.originalTemplate = Option.option((Object)originalTemplate);
            return this;
        }

        public ContentTemplateBuilder referencingBlueprint(ContentBlueprintId referencingBlueprint) {
            this.referencingBlueprint = Option.option((Object)referencingBlueprint);
            return this;
        }

        public ContentTemplateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ContentTemplateBuilder description(String description) {
            this.description = Strings.nullToEmpty((String)description);
            return this;
        }

        public ContentTemplateBuilder space(Space space) {
            this.space = space;
            return this;
        }

        public ContentTemplateBuilder labels(List<Label> labels) {
            this.labelsBuilder.addAll(labels);
            return this;
        }

        public ContentTemplateBuilder templateType(ContentTemplateType templateType) {
            this.templateType = templateType;
            return this;
        }

        public ContentTemplate build() {
            return new ContentTemplate(this);
        }
    }
}

