/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.permissions.Operation;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.TargetType;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class OperationCheckResult
implements Operation {
    @JsonProperty
    private final OperationKey operation;
    @JsonProperty
    private final TargetType targetType;

    @JsonCreator
    private OperationCheckResult() {
        this(OperationCheckResult.builder());
    }

    private OperationCheckResult(OperationCheckResultBuilder builder) {
        this.operation = builder.operationKey;
        this.targetType = builder.targetType;
    }

    public static OperationCheckResultBuilder builder() {
        return new OperationCheckResultBuilder();
    }

    @Override
    @JsonIgnore
    @Nonnull
    public OperationKey getOperationKey() {
        return this.operation;
    }

    @JsonIgnore
    @Nonnull
    public TargetType getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("operationKey", (Object)this.operation).add("targetType", (Object)this.targetType).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationCheckResult that = (OperationCheckResult)o;
        return Objects.equals(this.operation, that.operation) && Objects.equals(this.targetType, that.targetType);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.targetType);
    }

    public static class OperationCheckResultBuilder {
        private OperationKey operationKey;
        private TargetType targetType;

        public OperationCheckResult build() {
            Preconditions.checkNotNull((Object)this.operationKey, (Object)"operationKey must not be null");
            Preconditions.checkNotNull((Object)this.targetType, (Object)"targetType must not be null");
            return new OperationCheckResult(this);
        }

        public OperationCheckResultBuilder operationKey(@Nonnull OperationKey operationKey) {
            this.operationKey = operationKey;
            return this;
        }

        public OperationCheckResultBuilder targetType(@Nonnull TargetType targetType) {
            this.targetType = targetType;
            return this;
        }
    }
}

