/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.service.exceptions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.ValidationError;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;

@ExperimentalApi
public class ServiceException
extends RuntimeException {
    private final ValidationResult validationResult;

    public ServiceException() {
        this.validationResult = null;
    }

    public ServiceException(String message) {
        super(message);
        this.validationResult = null;
    }

    public ServiceException(Throwable throwable) {
        super(throwable);
        this.validationResult = null;
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.validationResult = null;
    }

    public ServiceException(String message, ValidationResult validationResult) {
        super(message);
        this.validationResult = validationResult;
    }

    public Option<ValidationResult> getOptionalValidationResult() {
        return Option.option((Object)this.validationResult);
    }

    @Override
    public String toString() {
        Iterable<ValidationError> errors;
        Option<ValidationResult> option;
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getName());
        String message = this.getMessage();
        if (message != null) {
            b.append(": ").append(message);
        }
        if ((option = this.getOptionalValidationResult()).isDefined() && (errors = ((ValidationResult)option.get()).getErrors()).iterator().hasNext()) {
            b.append(": ");
            b.append(Iterables.toString((Iterable)Iterables.transform(errors, (Function)new Function<ValidationError, String>(){

                public String apply(ValidationError input) {
                    return input.getMessage().toString();
                }
            })));
        }
        return b.toString();
    }
}

