/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.reference.Reference;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class Version {
    @JsonProperty
    private final Person by;
    @JsonProperty
    private final DateTime when;
    @JsonProperty
    private final String message;
    @JsonProperty
    private final int number;
    @JsonProperty
    private final boolean minorEdit;

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }

    public static VersionBuilder builder(Version version) {
        return new VersionBuilder().by(version.by).message(version.message).minorEdit(version.minorEdit).number(version.number).when((ReadableDateTime)version.when);
    }

    public static Reference<Version> buildReference(int number) {
        return Reference.collapsed(Version.class, (Map)ImmutableMap.of((Object)((Object)IdProperties.number), (Object)number));
    }

    @Deprecated
    public static Reference<Version> buildReference(Reference<Content> contentRef, int number) {
        return Version.buildReference(number);
    }

    public static int getVersionNumber(Reference<Version> versionRef) {
        return (Integer)versionRef.getIdProperty(IdProperties.number);
    }

    @JsonCreator
    private Version() {
        this.by = null;
        this.when = null;
        this.message = null;
        this.number = 0;
        this.minorEdit = false;
    }

    private Version(VersionBuilder builder) {
        this.by = builder.by;
        this.when = builder.when;
        this.message = builder.message;
        this.number = builder.number;
        this.minorEdit = builder.minorEdit;
    }

    public Person getBy() {
        return this.by;
    }

    public DateTime getWhen() {
        return this.when;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    public VersionBuilder nextBuilder() {
        return Version.builder().number(this.number + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.number == version.number;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("by", (Object)this.getBy()).add("when", (Object)this.getWhen()).add("number", this.getNumber()).add("message", (Object)this.getMessage()).toString();
    }

    public int hashCode() {
        return this.number;
    }

    public static class VersionBuilder {
        private Person by;
        private DateTime when;
        private String message;
        private int number;
        private boolean minorEdit;

        private VersionBuilder() {
        }

        public Version build() {
            return new Version(this);
        }

        public VersionBuilder by(Person by) {
            this.by = by;
            return this;
        }

        public VersionBuilder when(Date when) {
            this.when = new DateTime(Preconditions.checkNotNull((Object)when));
            return this;
        }

        public VersionBuilder when(ReadableDateTime readableDateTime) {
            this.when = readableDateTime.toDateTime();
            return this;
        }

        public VersionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public VersionBuilder number(int number) {
            this.number = number;
            return this;
        }

        public VersionBuilder minorEdit(boolean minorEdit) {
            this.minorEdit = minorEdit;
            return this;
        }
    }

    static enum IdProperties {
        number;

    }
}

