/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.permissions.Operation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonCreator;

@ExperimentalApi
public final class OperationKey
extends BaseApiEnum
implements Operation {
    public static final OperationKey USE = new OperationKey("use");
    public static final OperationKey CREATE = new OperationKey("create");
    public static final OperationKey READ = new OperationKey("read");
    public static final OperationKey UPDATE = new OperationKey("update");
    public static final OperationKey DELETE = new OperationKey("delete");
    public static final OperationKey COPY = new OperationKey("copy");
    public static final OperationKey MOVE = new OperationKey("move");
    public static final OperationKey EXPORT = new OperationKey("export");
    public static final OperationKey PURGE = new OperationKey("purge");
    public static final OperationKey PURGE_VERSION = new OperationKey("purge_version");
    public static final OperationKey ADMINISTER = new OperationKey("administer");
    public static final List<OperationKey> BUILT_IN = ImmutableList.of((Object)USE, (Object)CREATE, (Object)READ, (Object)UPDATE, (Object)DELETE, (Object)COPY, (Object)MOVE, (Object)EXPORT, (Object)PURGE, (Object)PURGE_VERSION, (Object)ADMINISTER);

    @JsonCreator
    public static OperationKey valueOf(String name) {
        for (OperationKey operationKey : BUILT_IN) {
            if (!operationKey.value.equals(name)) continue;
            return operationKey;
        }
        return new OperationKey(name);
    }

    private OperationKey(String name) {
        super((String)Preconditions.checkNotNull((Object)name));
    }

    @Deprecated
    public String getName() {
        return this.getValue();
    }

    @Override
    @Nonnull
    public OperationKey getOperationKey() {
        return this;
    }
}

