/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.pagination;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.google.common.base.Objects;

@ExperimentalApi
public class LimitedRequestImpl
implements LimitedRequest {
    private final int start;
    private final int limit;
    private final int needed;
    private final int maxLimit;

    public static LimitedRequest create(PageRequest request, int maxLimit) {
        return new LimitedRequestImpl(request, maxLimit);
    }

    public static LimitedRequest create(int maxLimit) {
        return new LimitedRequestImpl(0, maxLimit, maxLimit);
    }

    public static LimitedRequest create(int start, int limit, int maxLimit) {
        return new LimitedRequestImpl(start, limit, maxLimit);
    }

    protected LimitedRequestImpl(PageRequest request, int maxLimit) {
        this(request.getStart(), request.getLimit(), request.getLimit(), maxLimit);
    }

    protected LimitedRequestImpl(int start, int limit, int maxLimit) {
        this(start, Math.min(limit, maxLimit), Math.min(limit, maxLimit), maxLimit);
    }

    protected LimitedRequestImpl(int start, int limit, int needed, int maxLimit) {
        this.start = start;
        this.limit = Math.min(limit, maxLimit);
        this.needed = needed;
        if (maxLimit == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer.MAX_VALUE is not a sensible limit");
        }
        this.maxLimit = maxLimit;
    }

    @Override
    public int getNeeded() {
        return this.needed;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getMaxLimit() {
        return this.maxLimit;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("start", this.start).add("limit", this.limit).add("needed", this.needed).add("maxLimit", this.maxLimit).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.limit, this.maxLimit, this.needed, this.start});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !LimitedRequest.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        LimitedRequest other = (LimitedRequest)obj;
        return Objects.equal((Object)this.limit, (Object)other.getLimit()) && Objects.equal((Object)this.maxLimit, (Object)other.getMaxLimit()) && Objects.equal((Object)this.needed, (Object)other.getNeeded()) && Objects.equal((Object)this.start, (Object)other.getStart());
    }
}

