/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.reference.Collapsed;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;

class ContainerMap
extends HashMap<String, String>
implements Container {
    ContainerMap() {
    }

    public <T extends Container> T convertTo(Class<T> clazz) {
        if (clazz.equals(Content.class)) {
            ContentId id;
            String idStr = (String)this.get("id");
            String type = (String)this.get("type");
            if (idStr == null || type == null) {
                throw new IllegalStateException("Must provide id and type for Content");
            }
            Content.ContentBuilder builder = Content.builder();
            builder.type(ContentType.valueOf(type));
            try {
                id = ContentId.deserialise(idStr);
            }
            catch (BadRequestException e) {
                throw new UncheckedExecutionException((Throwable)e);
            }
            return (T)((Container)clazz.cast(builder.id(id).title((String)this.get("title")).build()));
        }
        if (clazz.equals(Space.class)) {
            String key;
            Space.SpaceBuilder builder = Space.builder();
            String id = (String)this.get("id");
            if (id != null) {
                builder.id(Long.parseLong(id));
            }
            if ((key = (String)this.get("key")) != null) {
                builder.key(key);
            }
            if (key == null && id == null) {
                throw new IllegalStateException("Must provide key or id for space");
            }
            return (T)((Container)clazz.cast(builder.name((String)this.get("name")).build()));
        }
        throw new IllegalArgumentException("Unsupported container class + " + clazz);
    }

    public static class CollapsedContainer
    implements Container,
    Collapsed {
        @Override
        public Navigation.Builder resolveNavigation(NavigationService navigationService) {
            return Navigation.Builder.NONE;
        }
    }
}

