/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.reference;

import com.atlassian.confluence.api.model.reference.CollapsedMap;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.nav.Navigation;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ModelMapBuilder<K, V> {
    private Map<K, V> delegate = Maps.newLinkedHashMap();
    ImmutableSet.Builder<K> collapsedEntries = ImmutableSet.builder();
    CollapsedMap<K, V> collapsedMap;
    Navigation.Builder navBuilder = null;
    private boolean isExpanded = false;

    private ModelMapBuilder() {
    }

    public static <K, V> ModelMapBuilder<K, V> newInstance() {
        return new ModelMapBuilder<K, V>();
    }

    public static <K, V> ModelMapBuilder<K, V> newInstance(Map<K, V> map) {
        return new ModelMapBuilder<K, V>().putAll(map);
    }

    public static <K, V> ModelMapBuilder<K, V> newExpandedInstance() {
        ModelMapBuilder<K, V> mapBuilder = ModelMapBuilder.newInstance();
        super.setExpanded(true);
        return mapBuilder;
    }

    public ModelMapBuilder<K, V> put(K key, V value) {
        this.setExpanded(true);
        if (key != null && value != null) {
            this.delegate.put(key, value);
        }
        return this;
    }

    public ModelMapBuilder<K, V> putAll(Map<K, ? extends V> map) {
        this.setExpanded(true);
        this.delegate.putAll(map);
        return this;
    }

    public ModelMapBuilder<K, V> addCollapsedEntry(K key) {
        this.setExpanded(true);
        this.collapsedEntries.add(key);
        return this;
    }

    public ModelMapBuilder<K, V> addCollapsedEntries(Set<K> collapsedEntries) {
        this.setExpanded(true);
        this.collapsedEntries.addAll(collapsedEntries);
        return this;
    }

    public ModelMapBuilder<K, V> copy(@Nonnull Map<K, V> map) {
        boolean expanded = !(map instanceof CollapsedMap);
        this.setExpanded(expanded);
        if (expanded) {
            this.delegate.clear();
            this.putAll(map);
            if (map instanceof EnrichableMap) {
                EnrichableMap enrichableMap = (EnrichableMap)map;
                this.addCollapsedEntries(enrichableMap.getCollapsedEntries());
                this.collapsedMap = null;
                this.navBuilder = enrichableMap.getNavigationBuilder();
            }
        } else {
            this.collapsedMap = (CollapsedMap)map;
            this.navBuilder = null;
        }
        return this;
    }

    public ModelMapBuilder<K, V> navigable(Navigation.Builder navBuilder) {
        this.navBuilder = navBuilder;
        return this;
    }

    private void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public Map<K, V> build() {
        if (this.isExpanded) {
            return new EnrichableMap(this, this.navBuilder);
        }
        if (this.collapsedMap != null) {
            return this.collapsedMap;
        }
        return new CollapsedMap();
    }

    protected ImmutableMap buildDelegate() {
        return ImmutableMap.builder().putAll(this.delegate).build();
    }
}

