/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions.spi;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.Target;
import com.atlassian.confluence.api.model.permissions.TargetType;
import com.atlassian.confluence.api.model.permissions.spi.OperationCheck;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Nonnull;

@ExperimentalSpi
public abstract class BaseOperationCheck
implements OperationCheck {
    private final OperationKey operationKey;
    private final TargetType expectedTargetType;

    protected BaseOperationCheck(OperationKey operationKey, TargetType expectedTargetType) {
        this.operationKey = (OperationKey)Preconditions.checkNotNull((Object)operationKey);
        this.expectedTargetType = (TargetType)Preconditions.checkNotNull((Object)expectedTargetType);
    }

    @Override
    @Nonnull
    public final OperationKey getOperationKey() {
        return this.operationKey;
    }

    @Override
    @Nonnull
    public final ValidationResult canPerform(Person person, Target target) {
        Map<Target, ValidationResult> map = this.canPerform(person, (Iterable<Target>)Option.some((Object)target));
        ValidationResult result = map.get(target);
        Preconditions.checkState((result != null && map.size() == 1 ? 1 : 0) != 0, (String)"OperationCheck subclass returned unexpected map contents for singleton canPerform: %s", (Object[])new Object[]{map});
        return result;
    }

    @Override
    @Nonnull
    public final ValidationResult canPerformAccordingToState(Person person, Target target) {
        Map<Target, ValidationResult> map = this.canPerformAccordingToState(person, (Iterable<Target>)Option.some((Object)target));
        ValidationResult result = map.get(target);
        Preconditions.checkState((result != null && map.size() == 1 ? 1 : 0) != 0, (String)"OperationCheck subclass returned unexpected map contents for singleton canPerform: %s", (Object[])new Object[]{map});
        return result;
    }

    @Override
    @Nonnull
    public final Map<Target, ValidationResult> canPerform(Person person, Iterable<Target> targets) {
        Preconditions.checkNotNull((Object)person);
        Preconditions.checkNotNull(targets);
        Preconditions.checkArgument((!Iterables.isEmpty(targets) ? 1 : 0) != 0, (Object)"At least one target must be supplied");
        for (Target target : targets) {
            Preconditions.checkNotNull((Object)target);
            Preconditions.checkArgument((boolean)this.expectedTargetType.equals(target.getTargetType()), (String)"Unsupported TargetType '%s' for operation '%s' on target: %s", (Object[])new Object[]{target.getTargetType(), this.getOperationKey(), target});
        }
        return this.canPerformImpl(person, targets);
    }

    @Override
    @Nonnull
    public final Map<Target, ValidationResult> canPerformAccordingToState(Person person, Iterable<Target> targets) {
        Preconditions.checkNotNull((Object)person);
        Preconditions.checkNotNull(targets);
        Preconditions.checkArgument((!Iterables.isEmpty(targets) ? 1 : 0) != 0, (Object)"At least one target must be supplied");
        for (Target target : targets) {
            Preconditions.checkNotNull((Object)target);
            Preconditions.checkArgument((boolean)this.expectedTargetType.equals(target.getTargetType()), (String)"Unsupported TargetType '%s' for operation '%s' on target: %s", (Object[])new Object[]{target.getTargetType(), this.getOperationKey(), target});
        }
        return this.canPerformAccordingToStateImpl(person, targets);
    }

    @Nonnull
    protected abstract Map<Target, ValidationResult> canPerformImpl(@Nonnull Person var1, @Nonnull Iterable<Target> var2);

    @Nonnull
    protected abstract Map<Target, ValidationResult> canPerformAccordingToStateImpl(@Nonnull Person var1, @Nonnull Iterable<Target> var2);
}

