/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.audit;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.model.audit.ChangedValue;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.serialization.DateTimeLongDeserializer;
import com.atlassian.confluence.api.serialization.DateTimeLongSerializer;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.joda.time.DateTime;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public final class AuditRecord {
    @JsonProperty
    private final User author;
    @JsonProperty
    private final String remoteAddress;
    @JsonDeserialize(using=DateTimeLongDeserializer.class)
    @JsonSerialize(using=DateTimeLongSerializer.class)
    @JsonProperty
    private final DateTime creationDate;
    @JsonProperty
    private final String summary;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final String category;
    @JsonProperty
    private final boolean sysAdmin;
    @JsonProperty
    private final AffectedObject affectedObject;
    @JsonProperty
    private final List<ChangedValue> changedValues;
    @JsonProperty
    private final Set<AffectedObject> associatedObjects;

    @JsonCreator
    private AuditRecord() {
        this(AuditRecord.builder());
    }

    private AuditRecord(Builder builder) {
        this.author = builder.author;
        this.remoteAddress = builder.remoteAddress;
        this.creationDate = builder.createdDate;
        this.summary = builder.summary;
        this.description = builder.description;
        this.category = builder.category;
        this.affectedObject = builder.affectedObject;
        this.changedValues = builder.changedValues;
        this.associatedObjects = builder.associatedObjects;
        this.sysAdmin = builder.isSysAdmin;
    }

    public User getAuthor() {
        return this.author;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public AffectedObject getAffectedObject() {
        return this.affectedObject;
    }

    public List<ChangedValue> getChangedValues() {
        return this.changedValues;
    }

    public Set<AffectedObject> getAssociatedObjects() {
        return this.associatedObjects;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isSysAdmin() {
        return this.sysAdmin;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AuditRecord other) {
        return new Builder(other);
    }

    public boolean equals(Object other) {
        if (!(other instanceof AuditRecord)) {
            return false;
        }
        AuditRecord auditRecord = (AuditRecord)other;
        return Objects.equals(auditRecord.author, this.author) && Objects.equals(auditRecord.remoteAddress, this.remoteAddress) && Objects.equals(auditRecord.creationDate, this.creationDate) && Objects.equals(auditRecord.summary, this.summary) && Objects.equals(auditRecord.description, this.description) && Objects.equals(auditRecord.category, this.category) && Objects.equals(auditRecord.affectedObject, this.affectedObject) && Objects.equals(auditRecord.changedValues, this.changedValues) && Objects.equals(auditRecord.associatedObjects, this.associatedObjects);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.remoteAddress, this.creationDate, this.summary, this.description, this.category, this.affectedObject, this.changedValues, this.associatedObjects);
    }

    public static class Builder {
        private User author = new User(null, "", "", "");
        private String summary = "";
        private String category = "";
        private String remoteAddress;
        private String description;
        private AffectedObject affectedObject = AffectedObject.none();
        private boolean isSysAdmin = false;
        private DateTime createdDate = DateTime.now();
        private List<ChangedValue> changedValues = Lists.newArrayList();
        private Set<AffectedObject> associatedObjects = Sets.newHashSet();

        public Builder() {
        }

        public Builder(AuditRecord other) {
            this.author = other.getAuthor();
            this.affectedObject = other.getAffectedObject();
            this.associatedObjects = other.getAssociatedObjects();
            this.category = other.getCategory();
            this.changedValues = other.getChangedValues();
            this.createdDate = other.getCreationDate();
            this.description = other.getDescription();
            this.isSysAdmin = other.isSysAdmin();
            this.remoteAddress = other.getRemoteAddress();
            this.summary = other.getSummary();
        }

        public Builder author(User user) {
            this.author = user;
            return this;
        }

        public Builder remoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public Builder createdDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder affectedObject(@Nonnull AffectedObject affectedObject) {
            this.affectedObject = affectedObject;
            return this;
        }

        public Builder changedValues(@Nonnull List<ChangedValue> changedValues) {
            this.changedValues = changedValues;
            return this;
        }

        public Builder changedValue(@Nonnull ChangedValue changedValue) {
            this.changedValues = Lists.newArrayList((Object[])new ChangedValue[]{changedValue});
            return this;
        }

        public Builder associatedObjects(@Nonnull Set<AffectedObject> associatedObjects) {
            this.associatedObjects = associatedObjects;
            return this;
        }

        public Builder associatedObject(@Nonnull AffectedObject associatedObject) {
            this.associatedObjects = Sets.newHashSet((Object[])new AffectedObject[]{associatedObject});
            return this;
        }

        public Builder isSysAdmin(boolean sysAdmin) {
            this.isSysAdmin = sysAdmin;
            return this;
        }

        public AuditRecord build() {
            return new AuditRecord(this);
        }
    }
}

