/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.javax.servlet.http;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaHttpServletResponseAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletRequestAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXCookieAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXHttpServletMappingAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXHttpSessionAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXHttpUpgradeHandlerAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXPartAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXPushBuilderAdapter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.servlet.http.PushBuilder;

public class JavaXHttpServletRequestAdapter
extends JavaXServletRequestAdapter
implements javax.servlet.http.HttpServletRequest {
    private final HttpServletRequest delegate;

    public JavaXHttpServletRequestAdapter(HttpServletRequest delegate) {
        super((ServletRequest)delegate);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public HttpServletRequest getDelegate() {
        return this.delegate;
    }

    public String getAuthType() {
        return this.delegate.getAuthType();
    }

    public javax.servlet.http.Cookie[] getCookies() {
        Cookie[] cookies = this.delegate.getCookies();
        if (cookies == null) {
            return null;
        }
        return (javax.servlet.http.Cookie[])Arrays.stream(cookies).map(JavaXCookieAdapter::new).toArray(javax.servlet.http.Cookie[]::new);
    }

    public long getDateHeader(String name) {
        return this.delegate.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.delegate.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.delegate.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.delegate.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.delegate.getIntHeader(name);
    }

    public HttpServletMapping getHttpServletMapping() {
        return WrapperUtil.applyIfNonNull(this.delegate.getHttpServletMapping(), JavaXHttpServletMappingAdapter::new);
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public String getPathInfo() {
        return this.delegate.getPathInfo();
    }

    public String getPathTranslated() {
        return this.delegate.getPathTranslated();
    }

    public PushBuilder newPushBuilder() {
        return WrapperUtil.applyIfNonNull(this.delegate.newPushBuilder(), JavaXPushBuilderAdapter::new);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public String getQueryString() {
        return this.delegate.getQueryString();
    }

    public String getRemoteUser() {
        return this.delegate.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.delegate.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.delegate.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.delegate.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.delegate.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.delegate.getRequestURL();
    }

    public String getServletPath() {
        return this.delegate.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return WrapperUtil.applyIfNonNull(this.delegate.getSession(create), JavaXHttpSessionAdapter::new);
    }

    public HttpSession getSession() {
        return WrapperUtil.applyIfNonNull(this.delegate.getSession(), JavaXHttpSessionAdapter::new);
    }

    public String changeSessionId() {
        return this.delegate.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.delegate.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.delegate.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.delegate.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.delegate.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        try {
            return this.delegate.authenticate((jakarta.servlet.http.HttpServletResponse)WrapperUtil.applyIfNonNull(response, JakartaHttpServletResponseAdapter::new));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void login(String username, String password) throws ServletException {
        try {
            this.delegate.login(username, password);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void logout() throws ServletException {
        try {
            this.delegate.logout();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        Collection parts;
        try {
            parts = this.delegate.getParts();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
        if (parts == null) {
            return null;
        }
        return parts.stream().map(JavaXPartAdapter::new).collect(Collectors.toList());
    }

    public Part getPart(String name) throws IOException, ServletException {
        try {
            return WrapperUtil.applyIfNonNull(this.delegate.getPart(name), JavaXPartAdapter::new);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        try {
            return (T)WrapperUtil.applyIfNonNull(this.delegate.upgrade(handlerClass), JavaXHttpUpgradeHandlerAdapter::new);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Map<String, String> getTrailerFields() {
        return this.delegate.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return this.delegate.isTrailerFieldsReady();
    }
}

