/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.javax.servlet;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.JakartaAdapters;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletRequestAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletResponseAdapter;
import com.atlassian.confluence.impl.adapter.javax.JavaXAdapters;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXAsyncContextAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXRequestDispatcherAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletContextAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletInputStreamAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXHttpServletRequestAdapter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JavaXServletRequestAdapter
implements ServletRequest {
    private final jakarta.servlet.ServletRequest delegate;

    public static ServletRequest from(jakarta.servlet.ServletRequest delegate) {
        if (delegate instanceof HttpServletRequest) {
            HttpServletRequest castDelegate = (HttpServletRequest)delegate;
            return new JavaXHttpServletRequestAdapter(castDelegate);
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXServletRequestAdapter::new);
    }

    protected JavaXServletRequestAdapter(jakarta.servlet.ServletRequest delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public jakarta.servlet.ServletRequest getDelegate() {
        return this.delegate;
    }

    public Object getAttribute(String name) {
        return JavaXAdapters.asJavaXIfJakarta(this.delegate.getAttribute(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.delegate.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.delegate.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public long getContentLengthLong() {
        return this.delegate.getContentLengthLong();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return WrapperUtil.applyIfNonNull(this.delegate.getInputStream(), JavaXServletInputStreamAdapter::new);
    }

    public String getParameter(String name) {
        return this.delegate.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.delegate.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.delegate.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.delegate.getParameterMap();
    }

    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    public String getScheme() {
        return this.delegate.getScheme();
    }

    public String getServerName() {
        return this.delegate.getServerName();
    }

    public int getServerPort() {
        return this.delegate.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.delegate.getReader();
    }

    public String getRemoteAddr() {
        return this.delegate.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.delegate.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.delegate.setAttribute(name, JakartaAdapters.asJakartaIfJavaX(o));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.delegate.getLocales();
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return WrapperUtil.applyIfNonNull(this.delegate.getRequestDispatcher(path), JavaXRequestDispatcherAdapter::new);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public int getRemotePort() {
        return this.delegate.getRemotePort();
    }

    public String getLocalName() {
        return this.delegate.getLocalName();
    }

    public String getLocalAddr() {
        return this.delegate.getLocalAddr();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public ServletContext getServletContext() {
        return WrapperUtil.applyIfNonNull(this.delegate.getServletContext(), JavaXServletContextAdapter::new);
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return WrapperUtil.applyIfNonNull(this.delegate.startAsync(), JavaXAsyncContextAdapter::new);
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return WrapperUtil.applyIfNonNull(this.delegate.startAsync(JakartaServletRequestAdapter.from(servletRequest), JakartaServletResponseAdapter.from(servletResponse)), JavaXAsyncContextAdapter::new);
    }

    public boolean isAsyncStarted() {
        return this.delegate.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.delegate.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return WrapperUtil.applyIfNonNull(this.delegate.getAsyncContext(), JavaXAsyncContextAdapter::new);
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.valueOf((String)this.delegate.getDispatcherType().name());
    }
}

