/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.javax.servlet;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.JakartaAdapters;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaFilterAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletContextAdapter;
import com.atlassian.confluence.impl.adapter.java.util.EnumerationAdapter;
import com.atlassian.confluence.impl.adapter.javax.JavaXAdapters;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXDynamicFilterRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXDynamicServletRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXFilterAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXFilterRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXRequestDispatcherAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXSessionCookieConfigAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.descriptor.JavaXJspConfigDescriptorAdapter;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionTrackingMode;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.descriptor.JspConfigDescriptor;

public class JavaXServletContextAdapter
implements javax.servlet.ServletContext {
    private final ServletContext delegate;

    public JavaXServletContextAdapter(ServletContext delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public javax.servlet.ServletContext getContext(String uripath) {
        return WrapperUtil.applyIfNonNull(this.delegate.getContext(uripath), JavaXServletContextAdapter::new);
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.delegate.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.delegate.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.delegate.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.delegate.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return WrapperUtil.applyIfNonNull(this.delegate.getRequestDispatcher(path), JavaXRequestDispatcherAdapter::new);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return WrapperUtil.applyIfNonNull(this.delegate.getNamedDispatcher(name), JavaXRequestDispatcherAdapter::new);
    }

    public javax.servlet.Servlet getServlet(String name) throws ServletException {
        try {
            return WrapperUtil.applyIfNonNull(this.delegate.getServlet(name), JavaXServletAdapter::new);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Enumeration<javax.servlet.Servlet> getServlets() {
        Enumeration servlets = this.delegate.getServlets();
        if (servlets == null) {
            return null;
        }
        return new EnumerationAdapter<Servlet, javax.servlet.Servlet>(this.delegate.getServlets(), JavaXServletAdapter::new);
    }

    public Enumeration<String> getServletNames() {
        return this.delegate.getServletNames();
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.delegate.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return JavaXAdapters.asJavaXIfJakarta(this.delegate.getAttribute(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.delegate.setAttribute(name, JakartaAdapters.asJakartaIfJavaX(object));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return WrapperUtil.applyIfNonNull(this.delegate.addServlet(servletName, className), JavaXDynamicServletRegistrationAdapter::new);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, javax.servlet.Servlet servlet) {
        return WrapperUtil.applyIfNonNull(this.delegate.addServlet(servletName, (Servlet)WrapperUtil.applyIfNonNull(servlet, JakartaServletAdapter::new)), JavaXDynamicServletRegistrationAdapter::new);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends javax.servlet.Servlet> servletClass) {
        return WrapperUtil.applyIfNonNull(this.delegate.addServlet(servletName, servletClass), JavaXDynamicServletRegistrationAdapter::new);
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return WrapperUtil.applyIfNonNull(this.delegate.addJspFile(servletName, jspFile), JavaXDynamicServletRegistrationAdapter::new);
    }

    public <T extends javax.servlet.Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)WrapperUtil.applyIfNonNull(this.delegate.createServlet(clazz), JavaXServletAdapter::new);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return WrapperUtil.applyIfNonNull(this.delegate.getServletRegistration(servletName), JavaXServletRegistrationAdapter::new);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        Map servletRegistrations = this.delegate.getServletRegistrations();
        if (servletRegistrations == null) {
            return null;
        }
        return servletRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> WrapperUtil.applyIfNonNull(e.getValue(), JavaXServletRegistrationAdapter::new)));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return WrapperUtil.applyIfNonNull(this.delegate.addFilter(filterName, className), JavaXDynamicFilterRegistrationAdapter::new);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, javax.servlet.Filter filter) {
        return WrapperUtil.applyIfNonNull(this.delegate.addFilter(filterName, (Filter)WrapperUtil.applyIfNonNull(filter, JakartaFilterAdapter::new)), JavaXDynamicFilterRegistrationAdapter::new);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends javax.servlet.Filter> filterClass) {
        return WrapperUtil.applyIfNonNull(this.delegate.addFilter(filterName, filterClass), JavaXDynamicFilterRegistrationAdapter::new);
    }

    public <T extends javax.servlet.Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)WrapperUtil.applyIfNonNull(this.delegate.createFilter(clazz), JavaXFilterAdapter::new);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return WrapperUtil.applyIfNonNull(this.delegate.getFilterRegistration(filterName), JavaXFilterRegistrationAdapter::new);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        Map filterRegistrations = this.delegate.getFilterRegistrations();
        if (filterRegistrations == null) {
            return null;
        }
        return filterRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> WrapperUtil.applyIfNonNull(e.getValue(), JavaXFilterRegistrationAdapter::new)));
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return WrapperUtil.applyIfNonNull(this.delegate.getSessionCookieConfig(), JavaXSessionCookieConfigAdapter::new);
    }

    public void setSessionTrackingModes(Set<javax.servlet.SessionTrackingMode> sessionTrackingModes) {
        this.delegate.setSessionTrackingModes(WrapperUtil.applyIfNonNull(sessionTrackingModes, JakartaServletContextAdapter::toJakartaSessionTrackingModeSet));
    }

    public Set<javax.servlet.SessionTrackingMode> getDefaultSessionTrackingModes() {
        return WrapperUtil.applyIfNonNull(this.delegate.getDefaultSessionTrackingModes(), JavaXServletContextAdapter::toJavaXSessionTrackingModeSet);
    }

    public Set<javax.servlet.SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return WrapperUtil.applyIfNonNull(this.delegate.getEffectiveSessionTrackingModes(), JavaXServletContextAdapter::toJavaXSessionTrackingModeSet);
    }

    public void addListener(String className) {
        this.delegate.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegate.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegate.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)this.delegate.createListener(clazz);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return WrapperUtil.applyIfNonNull(this.delegate.getJspConfigDescriptor(), JavaXJspConfigDescriptorAdapter::new);
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.delegate.getVirtualServerName();
    }

    public int getSessionTimeout() {
        return this.delegate.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.delegate.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.delegate.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.delegate.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.delegate.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.delegate.setResponseCharacterEncoding(encoding);
    }

    public static Set<javax.servlet.SessionTrackingMode> toJavaXSessionTrackingModeSet(Collection<SessionTrackingMode> sessionTrackingModes) {
        EnumSet<javax.servlet.SessionTrackingMode> result = EnumSet.noneOf(javax.servlet.SessionTrackingMode.class);
        for (SessionTrackingMode sessionTrackingMode : sessionTrackingModes) {
            result.add(javax.servlet.SessionTrackingMode.valueOf((String)sessionTrackingMode.name()));
        }
        return result;
    }
}

