/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.jakarta.servlet.http;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletRequestAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaCookieAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaHttpServletMappingAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaHttpSessionAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaHttpUpgradeHandlerAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaPartAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaPushBuilderAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.http.JavaXHttpServletResponseAdapter;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JakartaHttpServletRequestAdapter
extends JakartaServletRequestAdapter
implements HttpServletRequest {
    private final javax.servlet.http.HttpServletRequest delegate;

    public JakartaHttpServletRequestAdapter(javax.servlet.http.HttpServletRequest delegate) {
        super((ServletRequest)delegate);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public javax.servlet.http.HttpServletRequest getDelegate() {
        return this.delegate;
    }

    public String getAuthType() {
        return this.delegate.getAuthType();
    }

    public Cookie[] getCookies() {
        javax.servlet.http.Cookie[] cookies = this.delegate.getCookies();
        if (cookies == null) {
            return null;
        }
        return (Cookie[])Arrays.stream(cookies).map(JakartaCookieAdapter::new).toArray(Cookie[]::new);
    }

    public long getDateHeader(String name) {
        return this.delegate.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.delegate.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.delegate.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.delegate.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.delegate.getIntHeader(name);
    }

    public HttpServletMapping getHttpServletMapping() {
        return WrapperUtil.applyIfNonNull(this.delegate.getHttpServletMapping(), JakartaHttpServletMappingAdapter::new);
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public String getPathInfo() {
        return this.delegate.getPathInfo();
    }

    public String getPathTranslated() {
        return this.delegate.getPathTranslated();
    }

    public PushBuilder newPushBuilder() {
        return WrapperUtil.applyIfNonNull(this.delegate.newPushBuilder(), JakartaPushBuilderAdapter::new);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public String getQueryString() {
        return this.delegate.getQueryString();
    }

    public String getRemoteUser() {
        return this.delegate.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.delegate.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.delegate.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.delegate.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.delegate.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.delegate.getRequestURL();
    }

    public String getServletPath() {
        return this.delegate.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return WrapperUtil.applyIfNonNull(this.delegate.getSession(create), JakartaHttpSessionAdapter::new);
    }

    public HttpSession getSession() {
        return WrapperUtil.applyIfNonNull(this.delegate.getSession(), JakartaHttpSessionAdapter::new);
    }

    public String changeSessionId() {
        return this.delegate.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.delegate.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.delegate.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.delegate.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.delegate.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(jakarta.servlet.http.HttpServletResponse response) throws IOException, jakarta.servlet.ServletException {
        try {
            return this.delegate.authenticate((HttpServletResponse)WrapperUtil.applyIfNonNull(response, JavaXHttpServletResponseAdapter::new));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void login(String username, String password) throws jakarta.servlet.ServletException {
        try {
            this.delegate.login(username, password);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void logout() throws jakarta.servlet.ServletException {
        try {
            this.delegate.logout();
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public Collection<Part> getParts() throws IOException, jakarta.servlet.ServletException {
        Collection parts;
        try {
            parts = this.delegate.getParts();
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
        if (parts == null) {
            return null;
        }
        return parts.stream().map(JakartaPartAdapter::new).collect(Collectors.toList());
    }

    public Part getPart(String name) throws IOException, jakarta.servlet.ServletException {
        try {
            return WrapperUtil.applyIfNonNull(this.delegate.getPart(name), JakartaPartAdapter::new);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, jakarta.servlet.ServletException {
        try {
            return (T)WrapperUtil.applyIfNonNull(this.delegate.upgrade(handlerClass), JakartaHttpUpgradeHandlerAdapter::new);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public Map<String, String> getTrailerFields() {
        return this.delegate.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return this.delegate.isTrailerFieldsReady();
    }
}

