/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.jakarta.servlet;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletOutputStreamAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.http.JakartaHttpServletResponseAdapter;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class JakartaServletResponseAdapter
implements jakarta.servlet.ServletResponse {
    private final ServletResponse delegate;

    public static jakarta.servlet.ServletResponse from(ServletResponse delegate) {
        if (delegate instanceof HttpServletResponse) {
            HttpServletResponse castDelegate = (HttpServletResponse)delegate;
            return new JakartaHttpServletResponseAdapter(castDelegate);
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletResponseAdapter::new);
    }

    protected JakartaServletResponseAdapter(ServletResponse delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public ServletResponse getDelegate() {
        return this.delegate;
    }

    public String getCharacterEncoding() {
        return this.delegate.getCharacterEncoding();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return WrapperUtil.applyIfNonNull(this.delegate.getOutputStream(), JakartaServletOutputStreamAdapter::new);
    }

    public PrintWriter getWriter() throws IOException {
        return this.delegate.getWriter();
    }

    public void setCharacterEncoding(String charset) {
        this.delegate.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.delegate.setContentLength(len);
    }

    public void setContentLengthLong(long len) {
        this.delegate.setContentLengthLong(len);
    }

    public void setContentType(String type) {
        this.delegate.setContentType(type);
    }

    public void setBufferSize(int size) {
        this.delegate.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.delegate.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.delegate.flushBuffer();
    }

    public void resetBuffer() {
        this.delegate.resetBuffer();
    }

    public boolean isCommitted() {
        return this.delegate.isCommitted();
    }

    public void reset() {
        this.delegate.reset();
    }

    public void setLocale(Locale loc) {
        this.delegate.setLocale(loc);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }
}

