/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.jakarta.servlet;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.JakartaAdapters;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaDynamicFilterRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaDynamicServletRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaFilterAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaFilterRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaRequestDispatcherAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletRegistrationAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaSessionCookieConfigAdapter;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.descriptor.JakartaJspConfigDescriptorAdapter;
import com.atlassian.confluence.impl.adapter.java.util.EnumerationAdapter;
import com.atlassian.confluence.impl.adapter.javax.JavaXAdapters;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXFilterAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletContextAdapter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;

public class JakartaServletContextAdapter
implements ServletContext {
    private final javax.servlet.ServletContext delegate;

    public JakartaServletContextAdapter(javax.servlet.ServletContext delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return WrapperUtil.applyIfNonNull(this.delegate.getContext(uripath), JakartaServletContextAdapter::new);
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.delegate.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.delegate.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.delegate.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.delegate.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return WrapperUtil.applyIfNonNull(this.delegate.getRequestDispatcher(path), JakartaRequestDispatcherAdapter::new);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return WrapperUtil.applyIfNonNull(this.delegate.getNamedDispatcher(name), JakartaRequestDispatcherAdapter::new);
    }

    public Servlet getServlet(String name) throws jakarta.servlet.ServletException {
        try {
            return WrapperUtil.applyIfNonNull(this.delegate.getServlet(name), JakartaServletAdapter::new);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public Enumeration<Servlet> getServlets() {
        Enumeration servlets = this.delegate.getServlets();
        if (servlets == null) {
            return null;
        }
        return new EnumerationAdapter<javax.servlet.Servlet, Servlet>(this.delegate.getServlets(), JakartaServletAdapter::new);
    }

    public Enumeration<String> getServletNames() {
        return this.delegate.getServletNames();
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.delegate.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return JakartaAdapters.asJakartaIfJavaX(this.delegate.getAttribute(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.delegate.setAttribute(name, JavaXAdapters.asJavaXIfJakarta(object));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return WrapperUtil.applyIfNonNull(this.delegate.addServlet(servletName, className), JakartaDynamicServletRegistrationAdapter::new);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return WrapperUtil.applyIfNonNull(this.delegate.addServlet(servletName, (javax.servlet.Servlet)WrapperUtil.applyIfNonNull(servlet, JavaXServletAdapter::new)), JakartaDynamicServletRegistrationAdapter::new);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return WrapperUtil.applyIfNonNull(this.delegate.addServlet(servletName, servletClass), JakartaDynamicServletRegistrationAdapter::new);
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return WrapperUtil.applyIfNonNull(this.delegate.addJspFile(servletName, jspFile), JakartaDynamicServletRegistrationAdapter::new);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws jakarta.servlet.ServletException {
        try {
            return (T)WrapperUtil.applyIfNonNull(this.delegate.createServlet(clazz), JakartaServletAdapter::new);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return WrapperUtil.applyIfNonNull(this.delegate.getServletRegistration(servletName), JakartaServletRegistrationAdapter::new);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        Map servletRegistrations = this.delegate.getServletRegistrations();
        if (servletRegistrations == null) {
            return null;
        }
        return servletRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> WrapperUtil.applyIfNonNull(e.getValue(), JakartaServletRegistrationAdapter::new)));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return WrapperUtil.applyIfNonNull(this.delegate.addFilter(filterName, className), JakartaDynamicFilterRegistrationAdapter::new);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return WrapperUtil.applyIfNonNull(this.delegate.addFilter(filterName, (javax.servlet.Filter)WrapperUtil.applyIfNonNull(filter, JavaXFilterAdapter::new)), JakartaDynamicFilterRegistrationAdapter::new);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return WrapperUtil.applyIfNonNull(this.delegate.addFilter(filterName, filterClass), JakartaDynamicFilterRegistrationAdapter::new);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws jakarta.servlet.ServletException {
        try {
            return (T)WrapperUtil.applyIfNonNull(this.delegate.createFilter(clazz), JakartaFilterAdapter::new);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return WrapperUtil.applyIfNonNull(this.delegate.getFilterRegistration(filterName), JakartaFilterRegistrationAdapter::new);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        Map filterRegistrations = this.delegate.getFilterRegistrations();
        if (filterRegistrations == null) {
            return null;
        }
        return filterRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> WrapperUtil.applyIfNonNull(e.getValue(), JakartaFilterRegistrationAdapter::new)));
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return WrapperUtil.applyIfNonNull(this.delegate.getSessionCookieConfig(), JakartaSessionCookieConfigAdapter::new);
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.delegate.setSessionTrackingModes(WrapperUtil.applyIfNonNull(sessionTrackingModes, JavaXServletContextAdapter::toJavaXSessionTrackingModeSet));
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return WrapperUtil.applyIfNonNull(this.delegate.getDefaultSessionTrackingModes(), JakartaServletContextAdapter::toJakartaSessionTrackingModeSet);
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return WrapperUtil.applyIfNonNull(this.delegate.getEffectiveSessionTrackingModes(), JakartaServletContextAdapter::toJakartaSessionTrackingModeSet);
    }

    public void addListener(String className) {
        this.delegate.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegate.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegate.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws jakarta.servlet.ServletException {
        try {
            return (T)this.delegate.createListener(clazz);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return WrapperUtil.applyIfNonNull(this.delegate.getJspConfigDescriptor(), JakartaJspConfigDescriptorAdapter::new);
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.delegate.getVirtualServerName();
    }

    public int getSessionTimeout() {
        return this.delegate.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.delegate.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.delegate.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.delegate.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.delegate.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.delegate.setResponseCharacterEncoding(encoding);
    }

    public static Set<SessionTrackingMode> toJakartaSessionTrackingModeSet(Collection<javax.servlet.SessionTrackingMode> sessionTrackingModes) {
        EnumSet<SessionTrackingMode> result = EnumSet.noneOf(SessionTrackingMode.class);
        for (javax.servlet.SessionTrackingMode sessionTrackingMode : sessionTrackingModes) {
            result.add(SessionTrackingMode.valueOf((String)sessionTrackingMode.name()));
        }
        return result;
    }
}

