/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.jakarta.servlet;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaServletConfigAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletConfigAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletRequestAdapter;
import com.atlassian.confluence.impl.adapter.javax.servlet.JavaXServletResponseAdapter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class JakartaServletAdapter
implements jakarta.servlet.Servlet {
    private final Servlet delegate;

    public JakartaServletAdapter(Servlet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public Servlet getDelegate() {
        return this.delegate;
    }

    public void init(jakarta.servlet.ServletConfig servletConfig) throws jakarta.servlet.ServletException {
        try {
            this.delegate.init((ServletConfig)WrapperUtil.applyIfNonNull(servletConfig, JavaXServletConfigAdapter::new));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public jakarta.servlet.ServletConfig getServletConfig() {
        return WrapperUtil.applyIfNonNull(this.delegate.getServletConfig(), JakartaServletConfigAdapter::new);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws jakarta.servlet.ServletException, IOException {
        try {
            this.delegate.service(JavaXServletRequestAdapter.from(servletRequest), JavaXServletResponseAdapter.from(servletResponse));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

