/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.adapter.jakarta.servlet;

import com.atlassian.confluence.impl.adapter.WrapperUtil;
import com.atlassian.confluence.impl.adapter.jakarta.servlet.JakartaRegistrationAdapter;
import jakarta.servlet.DispatcherType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import javax.servlet.FilterRegistration;
import javax.servlet.Registration;

public class JakartaFilterRegistrationAdapter
extends JakartaRegistrationAdapter
implements jakarta.servlet.FilterRegistration {
    private final FilterRegistration delegate;

    public JakartaFilterRegistrationAdapter(FilterRegistration delegate) {
        super((Registration)delegate);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        this.delegate.addMappingForServletNames(WrapperUtil.applyIfNonNull(dispatcherTypes, JakartaFilterRegistrationAdapter::toJavaXDispatcherTypeSet), isMatchAfter, servletNames);
    }

    public Collection<String> getServletNameMappings() {
        return this.delegate.getServletNameMappings();
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        this.delegate.addMappingForUrlPatterns(WrapperUtil.applyIfNonNull(dispatcherTypes, JakartaFilterRegistrationAdapter::toJavaXDispatcherTypeSet), isMatchAfter, urlPatterns);
    }

    public Collection<String> getUrlPatternMappings() {
        return this.delegate.getUrlPatternMappings();
    }

    private static EnumSet<javax.servlet.DispatcherType> toJavaXDispatcherTypeSet(Collection<DispatcherType> dispatcherTypes) {
        EnumSet<javax.servlet.DispatcherType> result = EnumSet.noneOf(javax.servlet.DispatcherType.class);
        for (DispatcherType dispatcherType : dispatcherTypes) {
            result.add(javax.servlet.DispatcherType.valueOf((String)dispatcherType.name()));
        }
        return result;
    }
}

