/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml;

import com.atlassian.nekohtml.filters.HTMLWriterFilter;
import java.io.Writer;
import org.htmlunit.cyberneko.HTMLElements;
import org.htmlunit.cyberneko.xerces.xni.Augmentations;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;
import org.htmlunit.cyberneko.xerces.xni.XNIException;

class AttributeEntityNonResolvingWriter
extends HTMLWriterFilter {
    public AttributeEntityNonResolvingWriter(Writer writer, String encoding) {
        super(writer, encoding, new HTMLElements());
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.setSeenRootElement_(true);
        this.printStartElement(element, attributes, true);
    }

    protected void printStartElement(QName element, XMLAttributes attributes) {
        this.printStartElement(element, attributes, false);
    }

    protected void printStartElement(QName element, XMLAttributes attributes, boolean emptyElement) {
        int contentIndex = -1;
        String originalContent = null;
        if (element.getRawname().toLowerCase().equals("meta")) {
            String httpEquiv = null;
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String aname = attributes.getQName(i).toLowerCase();
                if (aname.equals("http-equiv")) {
                    httpEquiv = attributes.getValue(i);
                    continue;
                }
                if (!aname.equals("content")) continue;
                contentIndex = i;
            }
            if (httpEquiv != null && httpEquiv.toLowerCase().equals("content-type")) {
                Object content = null;
                if (contentIndex != -1) {
                    originalContent = attributes.getValue(contentIndex);
                    content = originalContent.toLowerCase();
                }
                if (content != null) {
                    int charsetIndex = ((String)content).indexOf("charset=");
                    content = charsetIndex != -1 ? ((String)content).substring(0, charsetIndex + 8) : (String)content + ";charset=";
                    content = (String)content + this.getEncoding_();
                    attributes.setValue(contentIndex, (String)content);
                }
            }
        }
        this.print("<");
        this.print(element.getRawname());
        int attrCount = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < attrCount; ++i) {
            String aname = attributes.getQName(i);
            String avalue = attributes.getValue(i);
            this.print(" ");
            this.print(aname);
            this.print("=\"");
            this.printAttributeValue(avalue);
            this.print("\"");
        }
        if (emptyElement) {
            this.print("/");
        }
        this.print(">");
        this.flush();
        if (contentIndex != -1) {
            attributes.setValue(contentIndex, originalContent);
        }
    }
}

