/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.persistence.dao.hibernate;

import bucket.user.propertyset.BucketPropertySetItem;
import com.opensymphony.module.propertyset.hibernate.HibernatePropertySetDAO;
import com.opensymphony.module.propertyset.hibernate.PropertySetItem;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BucketPropertySetDAO
extends HibernateDaoSupport
implements HibernatePropertySetDAO {
    private static final Logger log = LoggerFactory.getLogger(BucketPropertySetDAO.class);

    public void setImpl(PropertySetItem propertySetItem, boolean isUpdate) {
        if (isUpdate) {
            log.debug("Updating: {}", (Object)propertySetItem);
            this.getHibernateTemplate().update((Object)propertySetItem);
        } else {
            log.debug("Creating: {}", (Object)propertySetItem);
            this.getHibernateTemplate().save((Object)propertySetItem);
        }
    }

    @Transactional(readOnly=true)
    public Collection getKeys(String entityName, Long entityId, String prefix, int type) {
        org.hibernate.query.Query hibernateQuery = (org.hibernate.query.Query)this.getHibernateTemplate().execute(session -> {
            org.hibernate.query.Query query;
            if (prefix != null && type > 0) {
                query = session.getNamedQuery("all_keys_with_type_like");
                query.setString("like", prefix + "%");
                query.setInteger("type", type);
            } else if (prefix != null) {
                query = session.getNamedQuery("all_keys_like");
                query.setString("like", prefix + "%");
            } else if (type > 0) {
                query = session.getNamedQuery("all_keys_with_type");
                query.setInteger("type", type);
            } else {
                query = session.getNamedQuery("all_keys");
            }
            query.setString("entityName", entityName);
            query.setLong("entityId", entityId.longValue());
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getSessionFactory());
            return query;
        });
        try {
            return hibernateQuery.list();
        }
        catch (HibernateException e) {
            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)e);
        }
    }

    @Transactional(readOnly=true)
    public PropertySetItem findByKey(String entityName, Long entityId, String key) {
        return (BucketPropertySetItem)((Object)this.getHibernateTemplate().execute(session -> {
            try {
                return (BucketPropertySetItem)((Object)((Object)session.get(BucketPropertySetItem.class, (Serializable)((Object)new BucketPropertySetItem(entityName, entityId, key)))));
            }
            catch (ObjectDeletedException e) {
                return null;
            }
        }));
    }

    public void remove(String entityName, Long entityId, String key) {
        PropertySetItem item = this.findByKey(entityName, entityId, key);
        if (item == null) {
            return;
        }
        this.getHibernateTemplate().delete((Object)item);
    }
}

