/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate.schema;

import bucket.core.persistence.hibernate.ConfigurableLocalSessionFactoryBean;
import bucket.core.persistence.hibernate.MappingResources;
import bucket.core.persistence.hibernate.schema.Cleanup;
import bucket.core.persistence.hibernate.schema.ThreadLocalStdoutSuppresser;
import com.atlassian.annotations.Internal;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.HibernateConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.jcip.annotations.NotThreadSafe;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

@Deprecated
@NotThreadSafe
@Internal
public class SchemaHelper {
    public static final String COMPONENT_REFERENCE = "schemaHelper";
    private ResettableLazyReference<Configuration> configuration = new ResettableLazyReference<Configuration>(){

        protected Configuration create() throws Exception {
            Preconditions.checkState((SchemaHelper.this.hibernateProperties != null ? 1 : 0) != 0, (Object)"usage of deprecated ctor, either setHibernateProperties or setHibernateConfig should have been set");
            Configuration configuration = new Configuration();
            configuration.setProperties(SchemaHelper.this.hibernateProperties.get());
            for (String mappingResource : SchemaHelper.this.mappingResources) {
                configuration.addResource(mappingResource, Thread.currentThread().getContextClassLoader());
            }
            return configuration;
        }
    };
    private Iterable<String> mappingResources;
    private Supplier<Properties> hibernateProperties;

    @Deprecated
    public SchemaHelper() {
    }

    public SchemaHelper(Iterable<String> mappingResources, Properties hibernateProperties) {
        this.mappingResources = mappingResources;
        this.setHibernateProperties(hibernateProperties);
    }

    public SchemaHelper(Iterable<String> mappingResources, HibernateConfig hibernateConfig) {
        this.mappingResources = mappingResources;
        this.setHibernateConfig(hibernateConfig);
    }

    @Deprecated
    public void setHibernateProperties(Properties hibernateConfigProperties) {
        this.hibernateProperties = () -> hibernateConfigProperties;
    }

    @Deprecated
    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateProperties = () -> ((HibernateConfig)hibernateConfig).getHibernateProperties();
    }

    public Configuration getConfiguration() {
        return (Configuration)this.configuration.get();
    }

    @Deprecated
    public void setConfiguration(final Configuration configuration) {
        this.configuration = new ResettableLazyReference<Configuration>(){

            protected Configuration create() throws Exception {
                return configuration;
            }
        };
    }

    @Deprecated
    public MappingResources getMappingResources() {
        MappingResources mappingResources = new MappingResources();
        mappingResources.setMappings(Lists.newArrayList(this.mappingResources));
        return mappingResources;
    }

    @Deprecated
    public void setMappingResources(MappingResources mappings) {
        this.addMappingResources(mappings.getMappings());
    }

    @Deprecated
    public void addMappingResources(List<String> mappings) {
        this.mappingResources = Stream.concat(StreamSupport.stream(this.mappingResources.spliterator(), false), mappings.stream()).collect(Collectors.toList());
    }

    public void recreateDatabase() throws ConfigurationException {
        this.createTables();
    }

    public void dropTables() throws ConfigurationException {
        try {
            Metadata metadata = ConfigurableLocalSessionFactoryBean.getMetadata(this.getConfiguration());
            new SchemaExport().execute(EnumSet.of(TargetType.STDOUT, TargetType.DATABASE), SchemaExport.Action.DROP, metadata);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public void createTables() throws ConfigurationException {
        try {
            Metadata metadata = ConfigurableLocalSessionFactoryBean.getMetadata(this.getConfiguration());
            new SchemaExport().execute(EnumSet.of(TargetType.STDOUT, TargetType.DATABASE), SchemaExport.Action.BOTH, metadata);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public void updateSchemaIfNeeded() throws ConfigurationException {
        this.updateSchemaIfNeeded(false);
    }

    public void validateSchemaUpdateIfNeeded() throws ConfigurationException {
        try (Cleanup cleanup = ThreadLocalStdoutSuppresser.temporarilySuppressStdout();){
            Metadata metadata = ConfigurableLocalSessionFactoryBean.getMetadata(this.getConfiguration());
            new SchemaUpdate().execute(EnumSet.of(TargetType.STDOUT), metadata);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public void updateSchemaIfNeeded(boolean showDDL) throws ConfigurationException {
        try {
            EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
            if (showDDL) {
                targetTypes.add(TargetType.STDOUT);
            }
            Metadata metadata = ConfigurableLocalSessionFactoryBean.getMetadata(this.getConfiguration());
            new SchemaUpdate().execute(targetTypes, metadata);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public Iterable<String> getMappingResourcesView() {
        return this.mappingResources;
    }

    public void reset() {
        this.configuration.reset();
    }
}

