/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import bucket.core.persistence.hibernate.MappingResources;
import bucket.core.persistence.hibernate.MemoryOptimizedSingleTableEntityPersister;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.hibernate.adapter.adapters.ConnectionProviderV5Adapter;
import com.atlassian.hibernate.adapter.logging.HibernateLogConfigBridge;
import com.atlassian.hibernate.adapter.proxy.BytecodeProviderImpl_ImplementV2Proxy;
import com.atlassian.hibernate.util.DeprecationLogDisabler;
import com.atlassian.hibernate.util.reflection.ReflectionHelper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import net.sf.hibernate.connection.ConnectionProvider;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.orm.hibernate5.LocalSessionFactoryBuilder;

public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private static final Function<Object, Object> METADATA_SOURCES_FIELD = ReflectionHelper.INSTANCE.getPrivateFieldGetter(Configuration.class, "metadataSources");
    private Iterable<String> mappingResources;
    private HibernateConfig hibernateConfig;
    private LobHandler lobHandler;
    private DataSource dataSource;
    private final Function<DataSource, ConnectionProvider> connectionProviderSupplier;

    public static void configureHibernateSystem() {
        if (System.getProperty("hibernate.bytecode.use_reflection_optimizer") == null) {
            System.setProperty("hibernate.bytecode.use_reflection_optimizer", "true");
        }
        BytecodeProviderImpl_ImplementV2Proxy.install();
        HibernateLogConfigBridge.setLogLevels();
        DeprecationLogDisabler.disableLogging((String)"logDeprecationOfClassEntityTypeSelector", (boolean)false);
        DeprecationLogDisabler.disableLogging((String)"deprecatedLegacyCriteria", (boolean)false);
    }

    public ConfigurableLocalSessionFactoryBean(@Nonnull Function<DataSource, ConnectionProvider> connectionProviderSupplier) {
        this.connectionProviderSupplier = Objects.requireNonNull(connectionProviderSupplier);
    }

    @Deprecated
    public MappingResources getMappingResources() {
        MappingResources mappingResources = new MappingResources();
        mappingResources.setMappings((List)ImmutableList.of(this.mappingResources));
        return mappingResources;
    }

    @Required
    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    @Deprecated
    public void setMappingResources(MappingResources mappingResources) {
        this.setCurrentMappingResources(mappingResources.getMappings());
    }

    public Iterable<String> getCurrentMappingResources() {
        return this.mappingResources;
    }

    @Required
    public void setCurrentMappingResources(Iterable<String> mappingResources) {
        this.mappingResources = mappingResources;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static Metadata getMetadata(Configuration config) {
        Metadata metadata = (Metadata)config.getProperties().get(Metadata.class.getName());
        if (metadata == null) {
            metadata = ConfigurableLocalSessionFactoryBean.buildMetadata(config);
            config.getProperties().put(Metadata.class.getName(), metadata);
        }
        return metadata;
    }

    private static Metadata buildMetadata(Configuration config) {
        MetadataSources metadataSources = (MetadataSources)METADATA_SOURCES_FIELD.apply(config);
        StandardServiceRegistryBuilder serviceRegistryBuilder = config.getStandardServiceRegistryBuilder();
        serviceRegistryBuilder.applySettings((Map)config.getProperties());
        return metadataSources.getMetadataBuilder(serviceRegistryBuilder.build()).build();
    }

    public void afterPropertiesSet() throws IOException {
        this.setConfigLocations(new Resource[0]);
        super.setMappingResources((String[])Iterables.toArray(this.mappingResources, String.class));
        ConfigurableLocalSessionFactoryBean.getConfigTimeLobHandlerHolder().set(this.lobHandler);
        try {
            super.afterPropertiesSet();
        }
        finally {
            ConfigurableLocalSessionFactoryBean.getConfigTimeLobHandlerHolder().set(null);
        }
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder config) {
        this.prepareConfiguration((Configuration)config);
        return super.buildSessionFactory(config);
    }

    protected void prepareConfiguration(Configuration config) {
        config.addProperties(this.hibernateConfig.getHibernateProperties());
        config.getProperties().put("hibernate.connection.provider_class", ConnectionProviderV5Adapter.adapt((ConnectionProvider)this.connectionProviderSupplier.apply(this.dataSource)));
        MemoryOptimizedSingleTableEntityPersister.configure(config);
        this.setConfigLocation(null);
        super.setMappingResources((String[])Iterables.toArray(this.mappingResources, String.class));
    }

    private static ThreadLocal getConfigTimeLobHandlerHolder() {
        try {
            Field field = org.springframework.orm.hibernate.LocalSessionFactoryBean.class.getDeclaredField("configTimeLobHandlerHolder");
            field.setAccessible(true);
            return (ThreadLocal)field.get(null);
        }
        catch (ReflectiveOperationException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    static {
        ConfigurableLocalSessionFactoryBean.configureHibernateSystem();
    }
}

