/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import bucket.user.providers.ChainedCredentialsProvider;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.cache.CacheFactoryAware;
import com.opensymphony.util.TextUtils;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingCredentialsProvider
extends ChainedCredentialsProvider
implements CacheFactoryAware {
    private static String CACHE_KEY_CREDENTIALS_PROVIDER = CachingCredentialsProvider.class.getName();
    private static Logger log = LoggerFactory.getLogger(CachingCredentialsProvider.class);
    private Cache handlesCache;
    protected CacheFactory cacheFactory;

    @Override
    public boolean init(Properties properties) {
        boolean result = super.init(properties);
        if (ContainerManager.isContainerSetup()) {
            if (ContainerManager.getComponent((String)"cacheFactory") != null) {
                this.cacheFactory = (CacheFactory)ContainerManager.getComponent((String)"cacheFactory");
            }
            if (this.cacheFactory == null && ContainerManager.getComponent((String)"cacheManager") != null) {
                this.cacheFactory = (CacheManager)ContainerManager.getComponent((String)"cacheManager");
            }
            this.initCaches();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handles(String name) {
        boolean result;
        String lowercasedName = TextUtils.noNull((String)name).toLowerCase();
        try {
            Object element = this.handlesCache.get((Object)lowercasedName);
            if (element != null) {
                Boolean result2 = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug("Found cached handles() lookup for " + lowercasedName);
                }
                return result2;
            }
        }
        catch (Exception e) {
            log.error("Error accessing handlesCache:" + e, (Throwable)e);
        }
        Cache cache = this.handlesCache;
        synchronized (cache) {
            result = super.handles(name);
            this.handlesCache.put((Object)lowercasedName, (Object)result);
        }
        if (log.isDebugEnabled()) {
            log.debug("Caching handles() result for " + lowercasedName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            return super.create(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            boolean bl;
            try {
                log.debug("Updating Cache in advance to say user is removed");
                this.handlesCache.put((Object)name, (Object)false);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            try {
                bl = super.remove(name);
            }
            catch (Throwable throwable) {
                boolean newHandlesValue = super.handles(name);
                this.handlesCache.put((Object)name, (Object)newHandlesValue);
                if (log.isDebugEnabled()) {
                    log.debug("new handles value for " + name + " is " + newHandlesValue);
                }
                throw throwable;
            }
            boolean newHandlesValue = super.handles(name);
            this.handlesCache.put((Object)name, (Object)newHandlesValue);
            if (log.isDebugEnabled()) {
                log.debug("new handles value for " + name + " is " + newHandlesValue);
            }
            return bl;
        }
    }

    @Override
    public void flushCaches() {
        try {
            this.handlesCache.removeAll();
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        super.flushCaches();
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
        this.initCaches();
    }

    private void initCaches() {
        if (this.cacheFactory != null) {
            this.handlesCache = this.cacheFactory.getCache(CACHE_KEY_CREDENTIALS_PROVIDER);
        }
    }
}

