/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.persistence.dao.hibernate;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.user.provider.hibernate.dao.HibernateQueries;
import com.opensymphony.user.provider.hibernate.dao.HibernateUserDAO;
import com.opensymphony.user.provider.hibernate.entity.HibernateGroup;
import com.opensymphony.user.provider.hibernate.entity.HibernateUser;
import com.opensymphony.user.provider.hibernate.impl.HibernateUserImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class BucketUserDAO
extends HibernateDaoSupport
implements HibernateUserDAO {
    private static String CACHE_KEY_USER_DAO_USERNAME = BucketUserDAO.class.getName() + ".findUserByUsername()";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Cache userCache;

    private Cache getCache() {
        if (this.userCache == null) {
            CacheManager cacheManager = (CacheManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"cacheManager");
            this.userCache = cacheManager.getCache(CACHE_KEY_USER_DAO_USERNAME);
        }
        return this.userCache;
    }

    public void setUserCache(Cache userCache) {
        this.userCache = userCache;
    }

    public List findUsers() {
        return this.getHibernateTemplate().find(HibernateQueries.ALL_USERS);
    }

    public HibernateUser findUserByUsername(final String username) {
        Object element = this.getCache().get((Object)username);
        if (element != null) {
            Long userId = (Long)element;
            return (HibernateUser)this.getHibernateTemplate().get(HibernateUserImpl.class, (Serializable)userId);
        }
        Iterator ret = (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(HibernateQueries.USER_BY_USERNAME);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)BucketUserDAO.this.getSessionFactory());
                queryObject.setString(0, username);
                return queryObject.iterate();
            }
        });
        HibernateUser result = null;
        if (ret.hasNext()) {
            result = (HibernateUser)ret.next();
        }
        if (result == null) {
            this.getCache().put((Object)username, null);
        } else {
            this.getCache().put((Object)username, (Object)new Long(result.getId()));
        }
        return result;
    }

    public int deleteUserByUsername(String username) {
        List userByUserNameList = this.getHibernateTemplate().find("select distinct hibuser from com.opensymphony.user.provider.hibernate.entity.HibernateUser as hibuser where hibuser.name = ?", (Object)username, (Type)Hibernate.STRING);
        for (int i = 0; i < userByUserNameList.size(); ++i) {
            HibernateUser hibernateUser = (HibernateUser)userByUserNameList.get(i);
            for (Object o : hibernateUser.getGroupList()) {
                hibernateUser.removeGroup((HibernateGroup)o);
            }
        }
        try {
            this.getCache().remove((Object)username);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        if (userByUserNameList.size() > 0) {
            this.getHibernateTemplate().deleteAll((Collection)userByUserNameList);
            return userByUserNameList.size();
        }
        return 0;
    }

    public boolean updateUser(HibernateUser user) {
        try {
            this.getCache().remove((Object)user.getName());
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        return true;
    }

    public HibernateUser findUserByUsernameAndGroupname(final String userName, final String groupName) {
        List results = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(HibernateQueries.USER_BY_USERNAME_AND_GROUPNAME);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)BucketUserDAO.this.getSessionFactory());
                queryObject.setString(0, userName);
                queryObject.setString(1, groupName);
                return queryObject.list();
            }
        });
        if (results.size() == 0) {
            return null;
        }
        return (HibernateUser)results.get(0);
    }

    public boolean saveUser(HibernateUser user) {
        Serializable id;
        if (user != null) {
            try {
                this.getCache().remove((Object)user.getName());
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        return (id = this.getHibernateTemplate().save((Object)user)) != null;
    }
}

