/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate;

import bucket.core.persistence.ObjectDao;
import com.atlassian.bonnie.Indexer;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.hibernate.NonUniqueResultException;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public abstract class HibernateObjectDao
extends HibernateDaoSupport
implements ObjectDao {
    @Deprecated
    protected static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(HibernateObjectDao.class);
    private static final Logger LOG = LoggerFactory.getLogger(HibernateObjectDao.class);
    private Indexer indexer;

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    @Nullable
    protected EntityObject getByClassId(long id) {
        return (EntityObject)this.getHibernateTemplate().execute(session -> session.get(this.getPersistentClass(), (Serializable)Long.valueOf(id)));
    }

    @Override
    @Nonnull
    public <T> PageResponse<T> findByClassIds(Iterable<Long> ids, LimitedRequest limitedRequest, Predicate<? super T> filter) {
        int maxResultCount = limitedRequest.getLimit() + 1;
        return PageResponseImpl.filteredPageResponse((LimitedRequest)limitedRequest, (List)this.getHibernateTemplate().executeFind(session -> {
            Query queryObject = session.createQuery("from " + this.getPersistentClass().getName() + " s where s.id in (:ids)");
            queryObject.setParameterList("ids", (Collection)Lists.newArrayList((Iterable)ids));
            this.limitQuery(queryObject, limitedRequest.getStart(), maxResultCount);
            return queryObject.list();
        }), filter);
    }

    @Override
    @Nonnull
    public List findAll() {
        return this.findAllSorted(null);
    }

    @Override
    @Nonnull
    public List findAllSorted(String sortField) {
        return this.findAllSorted(sortField, true, -1, -1);
    }

    @Override
    @Nonnull
    public List findAllSorted(String sortField, boolean cacheable, int offset, int maxResultCount) {
        String query = "FROM " + this.getPersistentClass().getName() + " result";
        if (sortField != null) {
            query = query + " ORDER BY LOWER(result." + sortField + ")";
        }
        String finalQuery = query;
        List result = this.getHibernateTemplate().executeFind(session -> {
            Query queryObject = session.createQuery(finalQuery);
            queryObject.setCacheable(cacheable);
            SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)this.getSessionFactory());
            this.limitQuery(queryObject, offset, maxResultCount);
            return queryObject.list();
        });
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public void save(EntityObject objectToSave) {
        this.updateModificationData(objectToSave);
        this.saveRaw(objectToSave);
    }

    protected void updateModificationData(EntityObject objectToSave) {
        Date date = objectToSave.getCurrentDate();
        objectToSave.setLastModificationDate(date);
        if (objectToSave.getCreationDate() == null) {
            objectToSave.setCreationDate(date);
        }
    }

    @Override
    public void saveRaw(EntityObject objectToSave) {
        this.getHibernateTemplate().saveOrUpdate((Object)objectToSave);
        this.reIndex(objectToSave);
    }

    @Override
    public void remove(EntityObject objectToRemove) {
        try {
            this.getHibernateTemplate().delete((Object)objectToRemove);
            this.unIndex(objectToRemove, true);
        }
        catch (Exception e) {
            LOG.error("remove error!", (Throwable)e);
            throw new InfrastructureException((Throwable)e);
        }
    }

    @Override
    public void refresh(EntityObject objectToRefresh) {
        this.getHibernateTemplate().execute(session -> {
            session.refresh((Object)objectToRefresh);
            return null;
        });
    }

    @Override
    public void replicate(Object objectToReplicate) {
        this.getHibernateTemplate().execute(session -> {
            session.replicate(objectToReplicate, ReplicationMode.OVERWRITE);
            return null;
        });
    }

    protected void index(EntityObject objectToSave) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                this.indexer.index((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to index object: " + objectToSave + " -- " + e.getMessage(), (Throwable)e);
        }
    }

    protected void reIndex(EntityObject objectToSave) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                this.indexer.reIndex((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to reIndex object: " + objectToSave + " -- " + e.getMessage(), (Throwable)e);
        }
    }

    protected void unIndex(EntityObject objectToSave, boolean unindexDependents) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                if (unindexDependents) {
                    for (Object o : ((Searchable)objectToSave).getSearchableDependants()) {
                        this.unIndex((EntityObject)o, true);
                    }
                }
                this.indexer.unIndex((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to index object: " + objectToSave + " -- " + e.getMessage(), (Throwable)e);
        }
    }

    protected List findNamedQuery(String queryName) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, new Object[0]);
    }

    @Deprecated
    protected List findNamedQuery(String queryName, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, -1, new Object[0]);
    }

    protected List findNamedQuery(String queryName, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, new Object[0]);
    }

    @Deprecated
    protected List findNamedQuery(String queryName, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, maxResultCount, new Object[0]);
    }

    protected List findNamedQuery(String queryName, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, new Object[0]);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue);
    }

    @Deprecated
    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, -1, paramName, paramValue);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue);
    }

    @Deprecated
    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, maxResultCount, paramName, paramValue);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue, param2Name, param2Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, -1, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue, param2Name, param2Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, maxResultCount, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, -1, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, boolean cacheable, int offset, int maxResultCount, Object ... paramNamesAndValues) {
        return this.findNamedQueryStringParams(queryName, Cacheability.fromBoolean(cacheable), offset, maxResultCount, paramNamesAndValues);
    }

    protected List findNamedQueryStringParams(String queryName, Cacheability cacheability, int offset, int maxResultCount, Object ... paramNamesAndValues) {
        if (paramNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("There must be an even number of parameter names and values.");
        }
        return this.getHibernateTemplate().executeFind(session -> {
            Query queryObject = session.getNamedQuery(queryName);
            queryObject.setCacheable(cacheability == Cacheability.CACHEABLE);
            SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)this.getSessionFactory());
            for (int i = 0; i < paramNamesAndValues.length; i += 2) {
                String paramName = (String)paramNamesAndValues[i];
                if (paramName == null) {
                    throw new IllegalArgumentException("Parameter names cannot be null.");
                }
                Object paramValue = paramNamesAndValues[i + 1];
                if (paramValue instanceof Collection) {
                    Collection collection = (Collection)paramValue;
                    if (collection.isEmpty()) {
                        throw new IllegalArgumentException("Encountered empty collection for parameter: " + paramName + ". Hibernate does not support empty brackets after the sql 'in' clause.");
                    }
                    queryObject.setParameterList(paramName, collection);
                    continue;
                }
                queryObject.setParameter(paramName, paramValue);
            }
            this.limitQuery(queryObject, offset, maxResultCount);
            return queryObject.list();
        });
    }

    private void limitQuery(Query queryObject, int offset, int maxResultCount) {
        if (offset != -1) {
            queryObject.setFirstResult(offset);
        }
        if (maxResultCount != -1) {
            queryObject.setMaxResults(maxResultCount);
        }
    }

    protected int getCountResult(List<Integer> results) {
        if (results == null || results.isEmpty()) {
            LOG.error("Uh oh spaghettio - found no results for a count() query");
            return 0;
        }
        int result = results.get(0);
        if (results.size() != 1) {
            LOG.error("Uh oh - found more than one result when count query run: " + results);
        }
        return result;
    }

    @Deprecated
    @Nullable
    protected <T extends EntityObject> T findSingleObject(List<T> results) {
        if (results == null || results.isEmpty()) {
            return null;
        }
        EntityObject result = (EntityObject)results.get(0);
        if (results.size() != 1) {
            LOG.error("Uh oh - found more than one object when single object requested: " + results);
            for (EntityObject entity : results) {
                if (entity.getId() >= result.getId()) continue;
                result = entity;
            }
        }
        return (T)result;
    }

    protected <T extends EntityObject> T uniqueResult(List<T> results) throws NonUniqueResultException {
        if (results == null || results.isEmpty()) {
            return null;
        }
        Iterator<T> iterator = results.iterator();
        EntityObject firstResult = (EntityObject)iterator.next();
        while (iterator.hasNext()) {
            EntityObject nextResult = (EntityObject)iterator.next();
            if (firstResult == nextResult) continue;
            throw new NonUniqueResultException(results.size());
        }
        return (T)firstResult;
    }

    public static enum Cacheability {
        CACHEABLE,
        NOT_CACHEABLE;


        public static Cacheability fromBoolean(boolean flag) {
            return flag ? CACHEABLE : NOT_CACHEABLE;
        }
    }
}

